/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.animation.Bone;
import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.light.DirectionalLight;
import com.jme3.light.PointLight;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.data.FileBlockHeader;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.v249.ArmatureHelper;
import com.jme3.scene.plugins.blender.helpers.v249.CameraHelper;
import com.jme3.scene.plugins.blender.helpers.v249.ConstraintHelper;
import com.jme3.scene.plugins.blender.helpers.v249.CurvesHelper;
import com.jme3.scene.plugins.blender.helpers.v249.IpoHelper;
import com.jme3.scene.plugins.blender.helpers.v249.LightHelper;
import com.jme3.scene.plugins.blender.helpers.v249.MeshHelper;
import com.jme3.scene.plugins.blender.helpers.v249.ModifierHelper;
import com.jme3.scene.plugins.blender.structures.Ipo;
import com.jme3.scene.plugins.blender.structures.Modifier;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.DynamicArray;
import com.jme3.scene.plugins.blender.utils.Pointer;
import com.jme3.scene.plugins.ogre.AnimData;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ObjectHelper.class.getName());
    protected static final int OBJECT_TYPE_EMPTY = 0;
    protected static final int OBJECT_TYPE_MESH = 1;
    protected static final int OBJECT_TYPE_CURVE = 2;
    protected static final int OBJECT_TYPE_SURF = 3;
    protected static final int OBJECT_TYPE_TEXT = 4;
    protected static final int OBJECT_TYPE_METABALL = 5;
    protected static final int OBJECT_TYPE_LAMP = 10;
    protected static final int OBJECT_TYPE_CAMERA = 11;
    protected static final int OBJECT_TYPE_WAVE = 21;
    protected static final int OBJECT_TYPE_LATTICE = 22;
    protected static final int OBJECT_TYPE_ARMATURE = 25;
    protected boolean fixUpAxis;
    protected Quaternion upAxisRotationQuaternion;

    public ObjectHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public void setyIsUpAxis(boolean fixUpAxis) {
        this.fixUpAxis = fixUpAxis;
        if (fixUpAxis) {
            this.upAxisRotationQuaternion = new Quaternion().fromAngles(-1.5707964f, 0.0f, 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object toObject(Structure objectStructure, DataRepository dataRepository) throws BlenderFileException {
        loadedResult = dataRepository.getLoadedFeature(objectStructure.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (loadedResult != null) {
            return loadedResult;
        }
        dataRepository.pushParent(objectStructure);
        objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
        modifierHelper = (ModifierHelper)dataRepository.getHelper(ModifierHelper.class);
        armatureHelper = (ArmatureHelper)dataRepository.getHelper(ArmatureHelper.class);
        constraintHelper = (ConstraintHelper)dataRepository.getHelper(ConstraintHelper.class);
        type = ((Number)objectStructure.getFieldValue("type")).intValue();
        name = objectStructure.getName();
        ObjectHelper.LOGGER.log(Level.INFO, "Loading obejct: {0}", name);
        modifierHelper.readModifiers(objectStructure, dataRepository);
        objectAnimationModifier = objectHelper.readObjectAnimation(objectStructure, dataRepository);
        constraintHelper.loadConstraints(objectStructure, dataRepository);
        restrictflag = ((Number)objectStructure.getFieldValue("restrictflag")).intValue();
        visible = (restrictflag & 1) != 0;
        result = null;
        pParent = (Pointer)objectStructure.getFieldValue("parent");
        parent = dataRepository.getLoadedFeature(pParent.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (parent == null && !pParent.isNull()) {
            parentStructure = pParent.fetchData(dataRepository.getInputStream()).get(0);
            parent = this.toObject(parentStructure, dataRepository);
        }
        t = objectHelper.getTransformation(objectStructure);
        try {
            switch (type) {
                case 0: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing empty.");
                    empty = new Node(name);
                    empty.setLocalTransform(t);
                    result = empty;
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 1: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing mesh.");
                    node = new Node(name);
                    node.setCullHint(visible != false ? Spatial.CullHint.Always : Spatial.CullHint.Inherit);
                    meshHelper = (MeshHelper)dataRepository.getHelper(MeshHelper.class);
                    pMesh = (Pointer)objectStructure.getFieldValue("data");
                    meshesArray = pMesh.fetchData(dataRepository.getInputStream());
                    geometries = meshHelper.toMesh(meshesArray.get(0), dataRepository);
                    for (Geometry geometry : geometries) {
                        node.attachChild((Spatial)geometry);
                    }
                    node.setLocalTransform(t);
                    modifiers = dataRepository.getModifiers(objectStructure.getOldMemoryAddress(), null);
                    for (Modifier modifier : modifiers) {
                        modifierHelper.applyModifier(node, modifier, dataRepository);
                    }
                    if (objectAnimationModifier != null) {
                        node = modifierHelper.applyModifier(node, objectAnimationModifier, dataRepository);
                    }
                    if (parent instanceof Node) {
                        ((Node)parent).attachChild((Spatial)node);
                    }
                    node.updateModelBound();
                    result = node;
                    ** break;
lbl59:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing curve/nurb.");
                    pCurve = (Pointer)objectStructure.getFieldValue("data");
                    if (!pCurve.isNull()) {
                        curvesHelper = (CurvesHelper)dataRepository.getHelper(CurvesHelper.class);
                        curveData = pCurve.fetchData(dataRepository.getInputStream()).get(0);
                        curves = curvesHelper.toCurve(curveData, dataRepository);
                        result = new Node(name);
                        for (Geometry curve : curves) {
                            result.attachChild((Spatial)curve);
                        }
                        result.setLocalTransform(t);
                        ** break;
                    }
lbl74:
                    // 3 sources

                    break;
                }
                case 10: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing lamp.");
                    pLamp = (Pointer)objectStructure.getFieldValue("data");
                    if (!pLamp.isNull()) {
                        lightHelper = (LightHelper)dataRepository.getHelper(LightHelper.class);
                        light = lightHelper.toLight((lampsArray = pLamp.fetchData(dataRepository.getInputStream())).get(0), dataRepository);
                        if (light != null) {
                            light.setName(name);
                        }
                        if (light instanceof PointLight) {
                            ((PointLight)light).setPosition(t.getTranslation());
                        } else if (light instanceof DirectionalLight) {
                            quaternion = t.getRotation();
                            axes = new Vector3f[3];
                            quaternion.toAxes(axes);
                            ((DirectionalLight)light).setDirection(axes[2].negate());
                        } else {
                            ObjectHelper.LOGGER.log(Level.WARNING, "Unknown type of light: {0}", light);
                        }
                        result = light;
                        ** break;
                    }
lbl95:
                    // 3 sources

                    break;
                }
                case 11: {
                    pCamera = (Pointer)objectStructure.getFieldValue("data");
                    if (!pCamera.isNull()) {
                        cameraHelper = (CameraHelper)dataRepository.getHelper(CameraHelper.class);
                        camerasArray = pCamera.fetchData(dataRepository.getInputStream());
                        camera = cameraHelper.toCamera(camerasArray.get(0));
                        camera.setLocation(t.getTranslation());
                        camera.setRotation(t.getRotation());
                        result = camera;
                        ** break;
                    }
lbl106:
                    // 3 sources

                    break;
                }
                case 25: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing armature.");
                    pArmature = (Pointer)objectStructure.getFieldValue("data");
                    armaturesArray = pArmature.fetchData(dataRepository.getInputStream());
                    result = armatureHelper.toArmature(armaturesArray.get(0), dataRepository);
                    ** break;
lbl113:
                    // 1 sources

                    break;
                }
                default: {
                    ObjectHelper.LOGGER.log(Level.WARNING, "Unknown object type: {0}", type);
                    break;
                }
            }
        }
        finally {
            dataRepository.popParent();
        }
        if (result != null) {
            dataRepository.addLoadedFeatures(objectStructure.getOldMemoryAddress(), name, objectStructure, result);
        }
        return result;
    }

    public Transform getTransformation(Structure objectStructure) {
        DynamicArray loc = (DynamicArray)objectStructure.getFieldValue("loc");
        DynamicArray size = (DynamicArray)objectStructure.getFieldValue("size");
        DynamicArray rot = (DynamicArray)objectStructure.getFieldValue("rot");
        Pointer parent = (Pointer)objectStructure.getFieldValue("parent");
        Matrix4f parentInv = parent.isNull() ? Matrix4f.IDENTITY : this.getMatrix(objectStructure, "parentinv");
        Matrix4f globalMatrix = new Matrix4f();
        globalMatrix.setTranslation(((Number)loc.get(0)).floatValue(), ((Number)loc.get(1)).floatValue(), ((Number)loc.get(2)).floatValue());
        globalMatrix.setRotationQuaternion(new Quaternion().fromAngles(((Number)rot.get(0)).floatValue(), ((Number)rot.get(1)).floatValue(), ((Number)rot.get(2)).floatValue()));
        Matrix4f localMatrix = parentInv.mult(globalMatrix);
        Vector3f translation = localMatrix.toTranslationVector();
        Quaternion rotation = localMatrix.toRotationQuat();
        float scaleX = (float)Math.sqrt(parentInv.m00 * parentInv.m00 + parentInv.m10 * parentInv.m10 + parentInv.m20 * parentInv.m20);
        float scaleY = (float)Math.sqrt(parentInv.m01 * parentInv.m01 + parentInv.m11 * parentInv.m11 + parentInv.m21 * parentInv.m21);
        float scaleZ = (float)Math.sqrt(parentInv.m02 * parentInv.m02 + parentInv.m12 * parentInv.m12 + parentInv.m22 * parentInv.m22);
        Vector3f scale = new Vector3f(((Number)size.get(0)).floatValue() * scaleX, ((Number)size.get(1)).floatValue() * scaleY, ((Number)size.get(2)).floatValue() * scaleZ);
        if (this.fixUpAxis) {
            float y = translation.y;
            translation.y = translation.z;
            translation.z = y;
            rotation.multLocal(this.upAxisRotationQuaternion);
        }
        Transform t = new Transform(translation, rotation);
        t.setScale(scale);
        return t;
    }

    public Matrix4f getTransformationMatrix(Structure objectStructure) {
        return this.getMatrix(objectStructure, "obmat");
    }

    protected Matrix4f getMatrix(Structure objectStructure, String matrixName) {
        Matrix4f result = new Matrix4f();
        DynamicArray obmat = (DynamicArray)objectStructure.getFieldValue(matrixName);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                result.set(i, j, ((Number)obmat.get(j, i)).floatValue());
            }
        }
        return result;
    }

    public Modifier readObjectAnimation(Structure objectStructure, DataRepository dataRepository) throws BlenderFileException {
        Pointer pIpo = (Pointer)objectStructure.getFieldValue("ipo");
        if (!pIpo.isNull()) {
            String objectAnimationName = null;
            List<FileBlockHeader> actionBlocks = dataRepository.getFileBlocks(1094909952);
            for (FileBlockHeader actionBlock : actionBlocks) {
                Pointer pChannelIpo;
                Structure action = actionBlock.getStructure(dataRepository);
                List<Structure> actionChannels = ((Structure)action.getFieldValue("chanbase")).evaluateListBase(dataRepository);
                if (actionChannels.size() != 1 || !(pChannelIpo = (Pointer)actionChannels.get(0).getFieldValue("ipo")).equals(pIpo)) continue;
                objectAnimationName = action.getName();
                break;
            }
            String objectName = objectStructure.getName();
            if (objectAnimationName == null) {
                objectAnimationName = objectName;
            }
            IpoHelper ipoHelper = (IpoHelper)dataRepository.getHelper(IpoHelper.class);
            Structure ipoStructure = pIpo.fetchData(dataRepository.getInputStream()).get(0);
            Ipo ipo = ipoHelper.createIpo(ipoStructure, dataRepository);
            int[] animationFrames = dataRepository.getBlenderKey().getAnimationFrames(objectName, objectAnimationName);
            if (animationFrames == null) {
                animationFrames = new int[]{1, ipo.getLastFrame()};
            }
            int fps = dataRepository.getBlenderKey().getFps();
            float start = (float)animationFrames[0] / (float)fps;
            float stop = (float)animationFrames[1] / (float)fps;
            BoneTrack[] tracks = new BoneTrack[]{ipo.calculateTrack(0, animationFrames[0], animationFrames[1], fps)};
            BoneAnimation boneAnimation = new BoneAnimation(objectAnimationName, stop - start);
            boneAnimation.setTracks(tracks);
            ArrayList<BoneAnimation> animations = new ArrayList<BoneAnimation>(1);
            animations.add(boneAnimation);
            Transform t = this.getTransformation(objectStructure);
            Bone bone = new Bone(null);
            bone.setBindTransforms(t.getTranslation(), t.getRotation(), t.getScale());
            return new Modifier("ArmatureModifierData", new AnimData(new Skeleton(new Bone[]{bone}), animations), null);
        }
        return null;
    }

    public void clearState() {
        this.fixUpAxis = false;
    }
}

