/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.v249.IpoHelper;
import com.jme3.scene.plugins.blender.structures.Ipo;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.DynamicArray;
import com.jme3.scene.plugins.blender.utils.Pointer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArmatureHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ArmatureHelper.class.getName());
    protected Map<String, Integer> bonesMap = new HashMap<String, Integer>();
    protected Map<Bone, Long> bonesOMAs = new HashMap<Bone, Long>();
    protected List<BoneTransformationData> boneDataRoots = new ArrayList<BoneTransformationData>();

    public ArmatureHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Long getBoneOMA(Bone bone) {
        Long result = this.bonesOMAs.get(bone);
        if (result == null) {
            result = 0L;
        }
        return result;
    }

    public Skeleton toArmature(Structure structure, DataRepository dataRepository) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Converting structure to Armature!");
        Structure bonebase = (Structure)structure.getFieldValue("bonebase");
        List<Structure> bonesStructures = bonebase.evaluateListBase(dataRepository);
        for (Structure boneStructure : bonesStructures) {
            BoneTransformationData rootBoneTransformationData = this.readBoneAndItsChildren(boneStructure, null, dataRepository);
            this.boneDataRoots.add(rootBoneTransformationData);
        }
        return new Skeleton();
    }

    public Map<Integer, Integer> getGroupToBoneIndexMap(Structure defBaseStructure, DataRepository dataRepository) throws BlenderFileException {
        HashMap<Integer, Integer> result = null;
        if (this.bonesMap != null && this.bonesMap.size() != 0) {
            result = new HashMap<Integer, Integer>();
            List<Structure> deformGroups = defBaseStructure.evaluateListBase(dataRepository);
            int groupIndex = 0;
            for (Structure deformGroup : deformGroups) {
                String deformGroupName = deformGroup.getFieldValue("name").toString();
                Integer boneIndex = this.bonesMap.get(deformGroupName);
                if (boneIndex != null) {
                    result.put(groupIndex, boneIndex);
                }
                ++groupIndex;
            }
        }
        return result;
    }

    public BoneTrack[] getTracks(Structure actionStructure, DataRepository dataRepository, String objectName, String animationName) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Getting tracks!");
        IpoHelper ipoHelper = (IpoHelper)dataRepository.getHelper(IpoHelper.class);
        int fps = dataRepository.getBlenderKey().getFps();
        int[] animationFrames = dataRepository.getBlenderKey().getAnimationFrames(objectName, animationName);
        Structure chanbase = (Structure)actionStructure.getFieldValue("chanbase");
        List<Structure> actionChannels = chanbase.evaluateListBase(dataRepository);
        if (actionChannels != null && actionChannels.size() > 0 && (this.bonesMap == null || this.bonesMap.size() == 0)) {
            throw new IllegalStateException("No bones found! Cannot proceed to calculating tracks!");
        }
        ArrayList<BoneTrack> tracks = new ArrayList<BoneTrack>();
        for (Structure bActionChannel : actionChannels) {
            Pointer p;
            String name = bActionChannel.getFieldValue("name").toString();
            Integer boneIndex = this.bonesMap.get(name);
            if (boneIndex == null || (p = (Pointer)bActionChannel.getFieldValue("ipo")).isNull()) continue;
            Structure ipoStructure = p.fetchData(dataRepository.getInputStream()).get(0);
            Ipo ipo = ipoHelper.createIpo(ipoStructure, dataRepository);
            tracks.add(ipo.calculateTrack(boneIndex, animationFrames[0], animationFrames[1], fps));
        }
        return tracks.toArray(new BoneTrack[tracks.size()]);
    }

    protected Matrix4f getArmatureMatrix(Structure boneStructure) {
        DynamicArray boneMat = (DynamicArray)boneStructure.getFieldValue("arm_mat");
        Matrix4f m = new Matrix4f();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                m.set(i, j, ((Number)boneMat.get(j, i)).floatValue());
            }
        }
        return m;
    }

    protected BoneTransformationData readBoneAndItsChildren(Structure boneStructure, BoneTransformationData parent, DataRepository dataRepository) throws BlenderFileException {
        String name = boneStructure.getFieldValue("name").toString();
        Bone bone = new Bone(name);
        int bonesAmount = this.bonesOMAs.size();
        this.bonesOMAs.put(bone, boneStructure.getOldMemoryAddress());
        if (bonesAmount == this.bonesOMAs.size()) {
            throw new IllegalStateException("Two bones has the same hash value and thereforw a bone was overriden in the bones<->OMA map! Improve the hash algorithm!");
        }
        Matrix4f boneArmatureMatrix = this.getArmatureMatrix(boneStructure);
        DynamicArray sizeArray = (DynamicArray)boneStructure.getFieldValue("size");
        Vector3f size = new Vector3f(((Float)sizeArray.get(0)).floatValue(), ((Float)sizeArray.get(1)).floatValue(), ((Float)sizeArray.get(2)).floatValue());
        BoneTransformationData boneTransformationData = new BoneTransformationData(boneArmatureMatrix, size, bone, parent);
        dataRepository.addLoadedFeatures(boneStructure.getOldMemoryAddress(), name, boneStructure, bone);
        Structure childbase = (Structure)boneStructure.getFieldValue("childbase");
        List<Structure> children = childbase.evaluateListBase(dataRepository);
        for (Structure boneChild : children) {
            this.readBoneAndItsChildren(boneChild, boneTransformationData, dataRepository);
        }
        return boneTransformationData;
    }

    protected void assignBonesMatrices(BoneTransformationData btd, Matrix4f additionalRootBoneTransformation, List<Bone> boneList) {
        LOGGER.info("[" + btd.bone.getName() + "]  additionalRootBoneTransformation =\n" + additionalRootBoneTransformation);
        Matrix4f totalInverseParentMatrix = btd.parent != null ? btd.parent.totalInverseBoneParentMatrix : Matrix4f.IDENTITY;
        LOGGER.info("[" + btd.bone.getName() + "]  totalInverseParentMatrix =\n" + totalInverseParentMatrix);
        Matrix4f restMatrix = additionalRootBoneTransformation.mult(btd.boneArmatureMatrix);
        LOGGER.info("[" + btd.bone.getName() + "]  restMatrix =\n" + restMatrix);
        btd.totalInverseBoneParentMatrix = restMatrix.clone().invert();
        restMatrix = totalInverseParentMatrix.mult(restMatrix);
        LOGGER.info("[" + btd.bone.getName() + "]  resultMatrix =\n" + restMatrix);
        btd.bone.setBindTransforms(restMatrix.toTranslationVector(), restMatrix.toRotationQuat(), btd.size);
        boneList.add(btd.bone);
        this.bonesMap.put(btd.bone.getName(), boneList.size() - 1);
        if (btd.children != null && btd.children.size() > 0) {
            for (BoneTransformationData child : btd.children) {
                this.assignBonesMatrices(child, additionalRootBoneTransformation, boneList);
                btd.bone.addChild(child.bone);
            }
        }
    }

    public BoneTransformationData getBoneTransformationDataRoot(int index) {
        return this.boneDataRoots.get(index);
    }

    public int getBoneTransformationDataRootsSize() {
        return this.boneDataRoots.size();
    }

    public Bone[] buildBonesStructure(Long armatureOMA, Matrix4f additionalRootBoneTransformation) {
        ArrayList<Bone> bones = new ArrayList<Bone>(this.boneDataRoots.size() + 1);
        bones.add(new Bone(null));
        for (BoneTransformationData btd : this.boneDataRoots) {
            this.assignBonesMatrices(btd, additionalRootBoneTransformation, bones);
        }
        return bones.toArray(new Bone[bones.size()]);
    }

    public void assignBoneToOrphanedVertices(byte immovableBoneIndex, Mesh[] meshes) {
        VertexBuffer boneIndices = meshes[0].getBuffer(VertexBuffer.Type.BoneIndex);
        ByteBuffer data = (ByteBuffer)boneIndices.getData();
        for (int i = 0; i < boneIndices.getNumElements(); ++i) {
            if (data.get(i) != -1) continue;
            data.put(i, immovableBoneIndex);
        }
    }

    @Override
    public void clearState() {
        this.bonesMap.clear();
        this.boneDataRoots.clear();
    }

    private static class BoneTransformationData {
        private Matrix4f totalInverseBoneParentMatrix;
        private Matrix4f boneArmatureMatrix;
        private Vector3f size;
        private Bone bone;
        private BoneTransformationData parent;
        private List<BoneTransformationData> children;

        private BoneTransformationData(Matrix4f boneArmatureMatrix, Vector3f size, Bone bone, BoneTransformationData parent) {
            this.boneArmatureMatrix = boneArmatureMatrix;
            this.size = size;
            this.bone = bone;
            this.parent = parent;
            this.children = new ArrayList<BoneTransformationData>();
            if (this.parent != null) {
                this.parent.children.add(this);
            }
        }
    }
}

