/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers;

import com.jme3.animation.BoneTrack;
import com.jme3.scene.plugins.blender.data.FileBlockHeader;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.structures.BezierCurve;
import com.jme3.scene.plugins.blender.structures.Ipo;
import com.jme3.scene.plugins.blender.utils.BlenderInputStream;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.Pointer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArmatureHelper
extends com.jme3.scene.plugins.blender.helpers.v249.ArmatureHelper {
    private static final Logger LOGGER = Logger.getLogger(ArmatureHelper.class.getName());

    public ArmatureHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public BoneTrack[] getTracks(Structure actionStructure, DataRepository dataRepository, String objectName, String animationName) throws BlenderFileException {
        if (this.blenderVersion < 250) {
            return super.getTracks(actionStructure, dataRepository, objectName, animationName);
        }
        LOGGER.log(Level.INFO, "Getting tracks!");
        int fps = dataRepository.getBlenderKey().getFps();
        int[] animationFrames = dataRepository.getBlenderKey().getAnimationFrames(objectName, animationName);
        Structure groups = (Structure)actionStructure.getFieldValue("groups");
        List<Structure> actionGroups = groups.evaluateListBase(dataRepository);
        if (actionGroups != null && actionGroups.size() > 0 && (this.bonesMap == null || this.bonesMap.size() == 0)) {
            throw new IllegalStateException("No bones found! Cannot proceed to calculating tracks!");
        }
        ArrayList<BoneTrack> tracks = new ArrayList<BoneTrack>();
        for (Structure actionGroup : actionGroups) {
            String name = actionGroup.getFieldValue("name").toString();
            Integer boneIndex = (Integer)this.bonesMap.get(name);
            if (boneIndex == null) continue;
            List<Structure> channels = ((Structure)actionGroup.getFieldValue("channels")).evaluateListBase(dataRepository);
            BezierCurve[] bezierCurves = new BezierCurve[channels.size()];
            int channelCounter = 0;
            for (Structure c : channels) {
                BlenderInputStream bis = dataRepository.getInputStream();
                int currentPosition = bis.getPosition();
                Pointer pRnaPath = (Pointer)c.getFieldValue("rna_path");
                FileBlockHeader dataFileBlock = dataRepository.getFileBlock(pRnaPath.getOldMemoryAddress());
                bis.setPosition(dataFileBlock.getBlockPosition());
                String rnaPath = bis.readString();
                bis.setPosition(currentPosition);
                int arrayIndex = ((Number)c.getFieldValue("array_index")).intValue();
                int type = this.getCurveType(rnaPath, arrayIndex);
                Pointer pBezTriple = (Pointer)c.getFieldValue("bezt");
                List<Structure> bezTriples = pBezTriple.fetchData(dataRepository.getInputStream());
                bezierCurves[channelCounter++] = new BezierCurve(type, bezTriples, 2);
            }
            Ipo ipo = new Ipo(bezierCurves);
            tracks.add(ipo.calculateTrack(boneIndex, animationFrames[0], animationFrames[1], fps));
        }
        return tracks.toArray(new BoneTrack[tracks.size()]);
    }

    protected int getCurveType(String rnaPath, int arrayIndex) {
        if (rnaPath.endsWith(".location")) {
            return 1 + arrayIndex;
        }
        if (rnaPath.endsWith(".rotation_quaternion")) {
            return 25 + arrayIndex;
        }
        if (rnaPath.endsWith(".scale")) {
            return 13 + arrayIndex;
        }
        throw new IllegalStateException("Unknown curve rna path: " + rnaPath);
    }
}

