/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.BoneAnimation;
import com.jme3.animation.Skeleton;
import com.jme3.scene.plugins.blender.constraints.AbstractInfluenceFunction;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.IpoHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.Pointer;

public class Constraint {
    private final ConstraintType type;
    private final String name;
    private final Long boneOMA;
    private final Space ownerSpace;
    private final Space targetSpace;
    private final Structure data;
    private final IpoHelper.Ipo ipo;
    private final AbstractInfluenceFunction influenceFunction;

    public Constraint(Structure constraintStructure, AbstractInfluenceFunction influenceFunction, Long boneOMA, Space ownerSpace, Space targetSpace, IpoHelper.Ipo influenceIpo, DataRepository dataRepository) throws BlenderFileException {
        if (influenceFunction == null) {
            throw new IllegalArgumentException("Influence function is not defined!");
        }
        Pointer pData = (Pointer)constraintStructure.getFieldValue("data");
        if (pData.isNull()) {
            throw new BlenderFileException("The constraint has no data specified!");
        }
        this.data = pData.fetchData(dataRepository.getInputStream()).get(0);
        this.boneOMA = boneOMA;
        this.type = ConstraintType.valueOf(((Number)constraintStructure.getFieldValue("type")).intValue());
        this.name = constraintStructure.getFieldValue("name").toString();
        this.ownerSpace = ownerSpace;
        this.targetSpace = targetSpace;
        this.ipo = influenceIpo;
        this.influenceFunction = influenceFunction;
    }

    public String getName() {
        return this.name;
    }

    public Long getBoneOMA() {
        return this.boneOMA;
    }

    public Space getOwnerSpace() {
        return this.ownerSpace;
    }

    public Space getTargetSpace() {
        return this.targetSpace;
    }

    public ConstraintType getType() {
        return this.type;
    }

    public Structure getData() {
        return this.data;
    }

    public IpoHelper.Ipo getIpo() {
        return this.ipo;
    }

    public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation) {
        this.influenceFunction.affectAnimation(skeleton, boneAnimation, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Space {
        CONSTRAINT_SPACE_WORLD,
        CONSTRAINT_SPACE_LOCAL,
        CONSTRAINT_SPACE_POSE,
        CONSTRAINT_SPACE_PARLOCAL,
        CONSTRAINT_SPACE_INVALID;


        public static Space valueOf(byte c) {
            switch (c) {
                case 0: {
                    return CONSTRAINT_SPACE_WORLD;
                }
                case 1: {
                    return CONSTRAINT_SPACE_LOCAL;
                }
                case 2: {
                    return CONSTRAINT_SPACE_POSE;
                }
                case 3: {
                    return CONSTRAINT_SPACE_PARLOCAL;
                }
            }
            return CONSTRAINT_SPACE_INVALID;
        }
    }
}

