/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortUtil {
    private static final int INSERTION_SORT_THRESHOLD = 7;

    public static void gsort(Object[] a, Comparator comp) {
        int pos = 1;
        int last = 0;
        int length = a.length;
        while (pos < length) {
            if (comp.compare(a[pos], a[pos - 1]) >= 0) {
                if (last != 0) {
                    pos = last;
                    last = 0;
                }
                ++pos;
                continue;
            }
            Object tmp = a[pos];
            a[pos] = a[pos - 1];
            a[pos - 1] = tmp;
            if (pos > 1) {
                if (last == 0) {
                    last = pos;
                }
                --pos;
                continue;
            }
            ++pos;
        }
    }

    private static void test(Float[] original, Float[] sorted, Comparator<Float> ic) {
        int i;
        long time = System.nanoTime();
        for (i = 0; i < 1000000; ++i) {
            System.arraycopy(original, 0, sorted, 0, original.length);
            SortUtil.gsort(sorted, ic);
        }
        long dt = System.nanoTime() - time;
        System.out.println("GSort " + (double)dt / 1000000.0 + " ms");
        time = System.nanoTime();
        for (i = 0; i < 1000000; ++i) {
            System.arraycopy(original, 0, sorted, 0, original.length);
            SortUtil.qsort(sorted, ic);
        }
        dt = System.nanoTime() - time;
        System.out.println("QSort " + (double)dt / 1000000.0 + " ms");
        time = System.nanoTime();
        for (i = 0; i < 1000000; ++i) {
            System.arraycopy(original, 0, sorted, 0, original.length);
            SortUtil.msort(original, sorted, ic);
        }
        dt = System.nanoTime() - time;
        System.out.println("MSort " + (double)dt / 1000000.0 + " ms");
        time = System.nanoTime();
        for (i = 0; i < 1000000; ++i) {
            System.arraycopy(original, 0, sorted, 0, original.length);
            Arrays.sort(sorted, ic);
        }
        dt = System.nanoTime() - time;
        System.out.println("ASort " + (double)dt / 1000000.0 + " ms");
    }

    public static void main(String[] args) {
        Comparator<Float> ic = new Comparator<Float>(){

            @Override
            public int compare(Float o1, Float o2) {
                return (int)(o1.floatValue() - o2.floatValue());
            }
        };
        Float[] original = new Float[]{Float.valueOf(2.0f), Float.valueOf(1.0f), Float.valueOf(5.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(6.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(11.0f), Float.valueOf(10.0f), Float.valueOf(12.0f), Float.valueOf(13.0f), Float.valueOf(14.0f), Float.valueOf(15.0f), Float.valueOf(7.0f), Float.valueOf(19.0f), Float.valueOf(20.0f), Float.valueOf(18.0f), Float.valueOf(16.0f), Float.valueOf(17.0f), Float.valueOf(21.0f), Float.valueOf(23.0f), Float.valueOf(22.0f), Float.valueOf(24.0f), Float.valueOf(25.0f), Float.valueOf(27.0f), Float.valueOf(26.0f), Float.valueOf(29.0f), Float.valueOf(28.0f), Float.valueOf(30.0f), Float.valueOf(31.0f)};
        Float[] sorted = new Float[original.length];
        while (true) {
            SortUtil.test(original, sorted, ic);
        }
    }

    public static void qsort(Object[] a, Comparator comp) {
        SortUtil.qsort(a, 0, a.length - 1, comp);
    }

    public static void qsort(Object[] a, int lo0, int hi0, Comparator comp) {
        if (hi0 <= lo0) {
            return;
        }
        if (hi0 - lo0 == 1) {
            if (comp.compare(a[hi0], a[lo0]) < 0) {
                Object t = a[lo0];
                a[lo0] = a[hi0];
                a[hi0] = t;
            }
            return;
        }
        Object mid = a[(lo0 + hi0) / 2];
        int lo = lo0 - 1;
        int hi = hi0 + 1;
        while (true) {
            if (comp.compare(a[++lo], mid) < 0) {
                continue;
            }
            while (comp.compare(mid, a[--hi]) < 0) {
            }
            if (hi <= lo) break;
            Object t = a[lo];
            a[lo] = a[hi];
            a[hi] = t;
        }
        if (lo0 < lo - 1) {
            SortUtil.qsort(a, lo0, lo - 1, comp);
        }
        if (hi + 1 < hi0) {
            SortUtil.qsort(a, hi + 1, hi0, comp);
        }
    }

    public static void qsort(int[] a, int lo0, int hi0, Comparator comp) {
        if (hi0 <= lo0) {
            return;
        }
        if (hi0 - lo0 == 1) {
            if (comp.compare(a[hi0], a[lo0]) < 0) {
                int t = a[lo0];
                a[lo0] = a[hi0];
                a[hi0] = t;
            }
            return;
        }
        int mid = a[(lo0 + hi0) / 2];
        int lo = lo0 - 1;
        int hi = hi0 + 1;
        while (true) {
            if (comp.compare(a[++lo], mid) < 0) {
                continue;
            }
            while (comp.compare(mid, a[--hi]) < 0) {
            }
            if (hi <= lo) break;
            int t = a[lo];
            a[lo] = a[hi];
            a[hi] = t;
        }
        if (lo0 < lo - 1) {
            SortUtil.qsort(a, lo0, lo - 1, comp);
        }
        if (hi + 1 < hi0) {
            SortUtil.qsort(a, hi + 1, hi0, comp);
        }
    }

    public static void msort(Object[] src, Object[] dest, Comparator comp) {
        SortUtil.msort(src, dest, 0, src.length - 1, comp);
    }

    public static void msort(Object[] src, Object[] dest, int low, int high, Comparator comp) {
        if (low < high) {
            int center = (low + high) / 2;
            SortUtil.msort(src, dest, low, center, comp);
            SortUtil.msort(src, dest, center + 1, high, comp);
            SortUtil.merge(src, dest, low, center + 1, high, comp);
        }
    }

    private static void merge(Object[] src, Object[] dest, int low, int middle, int high, Comparator comp) {
        int leftEnd = middle - 1;
        int pos = low;
        int numElements = high - low + 1;
        while (low <= leftEnd && middle <= high) {
            if (comp.compare(src[low], src[middle]) <= 0) {
                dest[pos++] = src[low++];
                continue;
            }
            dest[pos++] = src[middle++];
        }
        while (low <= leftEnd) {
            dest[pos++] = src[low++];
        }
        while (middle <= high) {
            dest[pos++] = src[middle++];
        }
        int i = 0;
        while (i < numElements) {
            src[high] = dest[high];
            ++i;
            --high;
        }
    }
}

