/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.scene.VertexBuffer;
import com.jme3.terrain.geomipmap.TerrainPatch;
import java.nio.IntBuffer;

public class UpdatedTerrainPatch {
    private TerrainPatch updatedPatch;
    private int newLod;
    private int previousLod;
    private int rightLod;
    private int topLod;
    private int leftLod;
    private int bottomLod;
    private IntBuffer newIndexBuffer;
    private boolean reIndexNeeded = false;
    private boolean fixEdges = false;

    public UpdatedTerrainPatch(TerrainPatch updatedPatch, int newLod) {
        this.updatedPatch = updatedPatch;
        this.newLod = newLod;
    }

    public UpdatedTerrainPatch(TerrainPatch updatedPatch, int newLod, int prevLOD, boolean reIndexNeeded) {
        this.updatedPatch = updatedPatch;
        this.newLod = newLod;
        this.previousLod = prevLOD;
        this.reIndexNeeded = reIndexNeeded;
        if (this.newLod <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public String getName() {
        return this.updatedPatch.getName();
    }

    protected boolean lodChanged() {
        return this.reIndexNeeded && this.previousLod != this.newLod;
    }

    protected TerrainPatch getUpdatedPatch() {
        return this.updatedPatch;
    }

    protected void setUpdatedPatch(TerrainPatch updatedPatch) {
        this.updatedPatch = updatedPatch;
    }

    protected int getNewLod() {
        return this.newLod;
    }

    protected void setNewLod(int newLod) {
        this.newLod = newLod;
        if (this.newLod <= 0) {
            throw new IllegalArgumentException();
        }
    }

    protected IntBuffer getNewIndexBuffer() {
        return this.newIndexBuffer;
    }

    protected void setNewIndexBuffer(IntBuffer newIndexBuffer) {
        this.newIndexBuffer = newIndexBuffer;
    }

    protected int getRightLod() {
        return this.rightLod;
    }

    protected void setRightLod(int rightLod) {
        this.rightLod = rightLod;
    }

    protected int getTopLod() {
        return this.topLod;
    }

    protected void setTopLod(int topLod) {
        this.topLod = topLod;
    }

    protected int getLeftLod() {
        return this.leftLod;
    }

    protected void setLeftLod(int leftLod) {
        this.leftLod = leftLod;
    }

    protected int getBottomLod() {
        return this.bottomLod;
    }

    protected void setBottomLod(int bottomLod) {
        this.bottomLod = bottomLod;
    }

    public boolean isReIndexNeeded() {
        return this.reIndexNeeded;
    }

    public void setReIndexNeeded(boolean reIndexNeeded) {
        this.reIndexNeeded = reIndexNeeded;
    }

    public boolean isFixEdges() {
        return this.fixEdges;
    }

    public void setFixEdges(boolean fixEdges) {
        this.fixEdges = fixEdges;
    }

    public int getPreviousLod() {
        return this.previousLod;
    }

    public void setPreviousLod(int previousLod) {
        this.previousLod = previousLod;
    }

    public void updateAll() {
        this.updatedPatch.setLod(this.newLod);
        this.updatedPatch.setLodRight(this.rightLod);
        this.updatedPatch.setLodTop(this.topLod);
        this.updatedPatch.setLodLeft(this.leftLod);
        this.updatedPatch.setLodBottom(this.bottomLod);
        if (this.newIndexBuffer != null && (this.reIndexNeeded || this.fixEdges)) {
            this.updatedPatch.setPreviousLod(this.previousLod);
            this.updatedPatch.getMesh().clearBuffer(VertexBuffer.Type.Index);
            this.updatedPatch.getMesh().setBuffer(VertexBuffer.Type.Index, 3, this.newIndexBuffer);
        }
    }
}

