/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import android.app.Activity;
import android.content.res.Resources;
import com.jme3.asset.AndroidAssetManager;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.android.AndroidAudioRenderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.android.OGLESContext;
import com.jme3.util.AndroidLogHandler;
import com.jme3.util.JmeFormatter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmeSystem {
    private static final Logger logger = Logger.getLogger(JmeSystem.class.getName());
    private static boolean initialized = false;
    private static boolean lowPermissions = false;
    private static Resources res;
    private static Activity activity;

    public static void initialize(AppSettings settings) {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            JmeFormatter formatter = new JmeFormatter();
            AndroidLogHandler consoleHandler = new AndroidLogHandler();
            consoleHandler.setFormatter(formatter);
        }
        catch (SecurityException ex) {
            logger.log(Level.SEVERE, "Security error in creating log file", ex);
        }
        logger.info("Running on " + JmeSystem.getFullName());
    }

    public static String getFullName() {
        return "jMonkey Engine 3 ALPHA 0.7 Android";
    }

    public static void setLowPermissions(boolean lowPerm) {
        lowPermissions = lowPerm;
    }

    public static boolean isLowPermissions() {
        return lowPermissions;
    }

    public static JmeContext newContext(AppSettings settings, JmeContext.Type contextType) {
        JmeSystem.initialize(settings);
        return new OGLESContext();
    }

    public static AudioRenderer newAudioRenderer(AppSettings settings) {
        return new AndroidAudioRenderer(activity);
    }

    public static void setResources(Resources res) {
        JmeSystem.res = res;
    }

    public static Resources getResources() {
        return res;
    }

    public static void setActivity(Activity activity) {
        JmeSystem.activity = activity;
    }

    public static Activity getActivity() {
        return activity;
    }

    public static AssetManager newAssetManager() {
        logger.info("newAssetManager()");
        return new AndroidAssetManager(null);
    }

    public static AssetManager newAssetManager(URL url) {
        logger.info("newAssetManager(" + url + ")");
        return new AndroidAssetManager(url);
    }

    public static boolean showSettingsDialog(AppSettings settings, boolean loadSettings) {
        return true;
    }

    public static Platform getPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        return Platform.Android_Froyo;
    }

    public static enum Platform {
        Windows32,
        Windows64,
        Linux32,
        Linux64,
        MacOSX32,
        MacOSX64,
        MacOSX_PPC32,
        MacOSX_PPC64,
        Android_Froyo,
        Android_Gingerbread,
        Android_Honeycomb;

    }
}

