/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.texture.plugins.DDSLoader;
import com.jme3.texture.plugins.TGALoader;
import java.io.InputStream;
import java.util.logging.Logger;

class ImageLoader
extends AWTLoader {
    private static final Logger LOGGER = Logger.getLogger(ImageLoader.class.getName());
    protected DDSLoader ddsLoader = new DDSLoader();

    ImageLoader() {
    }

    public Image loadImage(BlenderInputStream inputStream, int startPosition, boolean flipY) {
        inputStream.setPosition(startPosition);
        Image result = this.loadImage((InputStream)inputStream, TextureHelper.ImageType.AWT, flipY);
        if (result == null) {
            inputStream.setPosition(startPosition);
            result = this.loadImage((InputStream)inputStream, TextureHelper.ImageType.TGA, flipY);
        }
        if (result == null) {
            inputStream.setPosition(startPosition);
            result = this.loadImage((InputStream)inputStream, TextureHelper.ImageType.DDS, flipY);
        }
        if (result == null) {
            LOGGER.warning("Image could not be loaded by none of available loaders!");
        }
        return result;
    }

    public Image loadImage(InputStream inputStream, TextureHelper.ImageType imageType, boolean flipY) {
        Image result = null;
        switch (imageType) {
            case AWT: {
                try {
                    result = this.load(inputStream, flipY);
                }
                catch (Exception e) {
                    LOGGER.info("Unable to load image using AWT loader!");
                }
                break;
            }
            case DDS: {
                try {
                    result = this.ddsLoader.load(inputStream);
                }
                catch (Exception e) {
                    LOGGER.info("Unable to load image using DDS loader!");
                }
                break;
            }
            case TGA: {
                try {
                    result = TGALoader.load(inputStream, flipY);
                }
                catch (Exception e) {
                    LOGGER.info("Unable to load image using TGA loader!");
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown image type: " + (Object)((Object)imageType));
            }
        }
        return result;
    }
}

