/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.control;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import java.io.IOException;

public class LightControl
extends AbstractControl {
    private Light light;
    private ControlDirection controlDir = ControlDirection.SpatialToLight;
    private static final String CONTROL_DIR_NAME = "controlDir";

    public LightControl() {
    }

    public LightControl(Light light) {
        this.light = light;
    }

    public LightControl(Light light, ControlDirection controlDir) {
        this.light = light;
        this.controlDir = controlDir;
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public ControlDirection getControlDir() {
        return this.controlDir;
    }

    public void setControlDir(ControlDirection controlDir) {
        this.controlDir = controlDir;
    }

    protected void controlUpdate(float tpf) {
        if (this.spatial != null && this.light != null) {
            switch (this.controlDir) {
                case SpatialToLight: {
                    this.spatialTolight(this.light);
                    break;
                }
                case LightToSpatial: {
                    this.lightToSpatial(this.light);
                }
            }
        }
    }

    private void spatialTolight(Light light) {
        if (light instanceof PointLight) {
            ((PointLight)light).setPosition(this.spatial.getWorldTranslation());
        }
        TempVars vars = TempVars.get();
        if (light instanceof DirectionalLight) {
            ((DirectionalLight)light).setDirection(vars.vect1.set(this.spatial.getWorldTranslation()).multLocal(-1.0f));
        }
        vars.release();
    }

    private void lightToSpatial(Light light) {
        Vector3f vecDiff;
        TempVars vars = TempVars.get();
        if (light instanceof PointLight) {
            PointLight pLight = (PointLight)light;
            vecDiff = vars.vect1.set(pLight.getPosition()).subtractLocal(this.spatial.getWorldTranslation());
            this.spatial.setLocalTranslation(vecDiff.addLocal(this.spatial.getLocalTranslation()));
        }
        if (light instanceof DirectionalLight) {
            DirectionalLight dLight = (DirectionalLight)light;
            vars.vect1.set(dLight.getDirection()).multLocal(-1.0f);
            vecDiff = vars.vect1.subtractLocal(this.spatial.getWorldTranslation());
            this.spatial.setLocalTranslation(vecDiff.addLocal(this.spatial.getLocalTranslation()));
        }
        vars.release();
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial newSpatial) {
        LightControl control = new LightControl(this.light, this.controlDir);
        control.setSpatial(newSpatial);
        control.setEnabled(this.isEnabled());
        return control;
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        im.getCapsule(this).readEnum(CONTROL_DIR_NAME, ControlDirection.class, ControlDirection.SpatialToLight);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        ex.getCapsule(this).write(this.controlDir, CONTROL_DIR_NAME, ControlDirection.SpatialToLight);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlDirection {
        LightToSpatial,
        SpatialToLight;

    }
}

