/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.bih.BIHTree;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix4f;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.CollisionData;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.scene.mesh.IndexByteBuffer;
import com.jme3.scene.mesh.IndexIntBuffer;
import com.jme3.scene.mesh.IndexShortBuffer;
import com.jme3.scene.mesh.VirtualIndexBuffer;
import com.jme3.scene.mesh.WrappedIndexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mesh
implements Savable,
Cloneable {
    private BoundingVolume meshBound = new BoundingBox();
    private CollisionData collisionTree = null;
    private ArrayList<VertexBuffer> buffersList = new ArrayList(5);
    private IntMap<VertexBuffer> buffers = new IntMap();
    private VertexBuffer[] lodLevels;
    private float pointSize = 1.0f;
    private float lineWidth = 1.0f;
    private transient int vertexArrayID = -1;
    private int vertCount = -1;
    private int elementCount = -1;
    private int maxNumWeights = -1;
    private int[] elementLengths;
    private int[] modeStart;
    private Mode mode = Mode.Triangles;

    public Mesh clone() {
        try {
            Mesh clone = (Mesh)super.clone();
            clone.meshBound = this.meshBound.clone();
            clone.collisionTree = this.collisionTree != null ? this.collisionTree : null;
            clone.buffers = this.buffers.clone();
            clone.buffersList = new ArrayList<VertexBuffer>(this.buffersList);
            clone.vertexArrayID = -1;
            if (this.elementLengths != null) {
                clone.elementLengths = (int[])this.elementLengths.clone();
            }
            if (this.modeStart != null) {
                clone.modeStart = (int[])this.modeStart.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Mesh deepClone() {
        try {
            Mesh clone = (Mesh)super.clone();
            clone.meshBound = this.meshBound != null ? this.meshBound.clone() : null;
            clone.collisionTree = null;
            clone.buffers = new IntMap();
            clone.buffersList = new ArrayList();
            for (IntMap.Entry<VertexBuffer> entry : this.buffers) {
                VertexBuffer bufClone = entry.getValue().clone();
                clone.buffers.put(entry.getKey(), bufClone);
                clone.buffersList.add(bufClone);
            }
            clone.vertexArrayID = -1;
            clone.vertCount = -1;
            clone.elementCount = -1;
            clone.maxNumWeights = this.maxNumWeights;
            clone.elementLengths = this.elementLengths != null ? (int[])this.elementLengths.clone() : null;
            clone.modeStart = this.modeStart != null ? (int[])this.modeStart.clone() : null;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Mesh cloneForAnim() {
        Mesh clone = this.clone();
        if (this.getBuffer(VertexBuffer.Type.BindPosePosition) != null) {
            VertexBuffer oldPos = this.getBuffer(VertexBuffer.Type.Position);
            VertexBuffer newPos = oldPos.clone();
            clone.clearBuffer(VertexBuffer.Type.Position);
            clone.setBuffer(newPos);
            if (this.getBuffer(VertexBuffer.Type.BindPoseNormal) != null) {
                VertexBuffer oldNorm = this.getBuffer(VertexBuffer.Type.Normal);
                VertexBuffer newNorm = oldNorm.clone();
                clone.clearBuffer(VertexBuffer.Type.Normal);
                clone.setBuffer(newNorm);
            }
        }
        return clone;
    }

    public void generateBindPose(boolean forSoftwareAnim) {
        if (forSoftwareAnim) {
            VertexBuffer pos = this.getBuffer(VertexBuffer.Type.Position);
            if (pos == null || this.getBuffer(VertexBuffer.Type.BoneIndex) == null) {
                return;
            }
            VertexBuffer bindPos = new VertexBuffer(VertexBuffer.Type.BindPosePosition);
            bindPos.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone(pos.getData()));
            this.setBuffer(bindPos);
            pos.setUsage(VertexBuffer.Usage.Stream);
            VertexBuffer norm = this.getBuffer(VertexBuffer.Type.Normal);
            if (norm != null) {
                VertexBuffer bindNorm = new VertexBuffer(VertexBuffer.Type.BindPoseNormal);
                bindNorm.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone(norm.getData()));
                this.setBuffer(bindNorm);
                norm.setUsage(VertexBuffer.Usage.Stream);
            }
        }
    }

    public void prepareForAnim(boolean forSoftwareAnim) {
        if (forSoftwareAnim) {
            VertexBuffer indices = this.getBuffer(VertexBuffer.Type.BoneIndex);
            ByteBuffer originalIndex = (ByteBuffer)indices.getData();
            ByteBuffer arrayIndex = ByteBuffer.allocate(originalIndex.capacity());
            originalIndex.clear();
            arrayIndex.put(originalIndex);
            indices.updateData(arrayIndex);
            VertexBuffer weights = this.getBuffer(VertexBuffer.Type.BoneWeight);
            FloatBuffer originalWeight = (FloatBuffer)weights.getData();
            FloatBuffer arrayWeight = FloatBuffer.allocate(originalWeight.capacity());
            originalWeight.clear();
            arrayWeight.put(originalWeight);
            weights.updateData(arrayWeight);
        }
    }

    public void setLodLevels(VertexBuffer[] lodLevels) {
        this.lodLevels = lodLevels;
    }

    public int getNumLodLevels() {
        return this.lodLevels != null ? this.lodLevels.length : 0;
    }

    public VertexBuffer getLodLevel(int lod) {
        return this.lodLevels[lod];
    }

    public int[] getElementLengths() {
        return this.elementLengths;
    }

    public void setElementLengths(int[] elementLengths) {
        this.elementLengths = elementLengths;
    }

    public int[] getModeStart() {
        return this.modeStart;
    }

    public void setModeStart(int[] modeStart) {
        this.modeStart = modeStart;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.updateCounts();
    }

    public int getMaxNumWeights() {
        return this.maxNumWeights;
    }

    public void setMaxNumWeights(int maxNumWeights) {
        this.maxNumWeights = maxNumWeights;
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(float pointSize) {
        this.pointSize = pointSize;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setStatic() {
        for (IntMap.Entry<VertexBuffer> entry : this.buffers) {
            entry.getValue().setUsage(VertexBuffer.Usage.Static);
        }
    }

    public void setDynamic() {
        for (IntMap.Entry<VertexBuffer> entry : this.buffers) {
            entry.getValue().setUsage(VertexBuffer.Usage.Dynamic);
        }
    }

    public void setStreamed() {
        for (IntMap.Entry<VertexBuffer> entry : this.buffers) {
            entry.getValue().setUsage(VertexBuffer.Usage.Stream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setInterleaved() {
        void var3_6;
        ArrayList<VertexBuffer> vbs = new ArrayList<VertexBuffer>();
        for (IntMap.Entry<VertexBuffer> entry : this.buffers) {
            vbs.add(entry.getValue());
        }
        vbs.remove(this.getBuffer(VertexBuffer.Type.Index));
        int stride = 0;
        boolean bl = false;
        while (var3_6 < vbs.size()) {
            VertexBuffer vb = (VertexBuffer)vbs.get((int)var3_6);
            stride += vb.componentsLength;
            vb.getData().clear();
            ++var3_6;
        }
        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Type.InterleavedData);
        ByteBuffer dataBuf = BufferUtils.createByteBuffer(stride * this.getVertexCount());
        vertexBuffer.setupData(VertexBuffer.Usage.Static, 1, VertexBuffer.Format.UnsignedByte, dataBuf);
        this.buffers.put(VertexBuffer.Type.InterleavedData.ordinal(), vertexBuffer);
        this.buffersList.add(vertexBuffer);
        for (int vert = 0; vert < this.getVertexCount(); ++vert) {
            block10: for (int i = 0; i < vbs.size(); ++i) {
                VertexBuffer vb = (VertexBuffer)vbs.get(i);
                switch (vb.getFormat()) {
                    case Float: {
                        FloatBuffer fb = (FloatBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.putFloat(fb.get());
                        }
                        continue block10;
                    }
                    case Byte: 
                    case UnsignedByte: {
                        ByteBuffer bb = (ByteBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.put(bb.get());
                        }
                        continue block10;
                    }
                    case Half: 
                    case Short: 
                    case UnsignedShort: {
                        ShortBuffer sb = (ShortBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.putShort(sb.get());
                        }
                        continue block10;
                    }
                    case Int: 
                    case UnsignedInt: {
                        IntBuffer ib = (IntBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.putInt(ib.get());
                        }
                        continue block10;
                    }
                    case Double: {
                        DoubleBuffer db = (DoubleBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.putDouble(db.get());
                        }
                        continue block10;
                    }
                }
            }
        }
        int offset = 0;
        for (VertexBuffer vb : vbs) {
            vb.setOffset(offset);
            vb.setStride(stride);
            vb.updateData(null);
            offset += vb.componentsLength;
        }
    }

    private int computeNumElements(int bufSize) {
        switch (this.mode) {
            case Triangles: {
                return bufSize / 3;
            }
            case TriangleFan: 
            case TriangleStrip: {
                return bufSize - 2;
            }
            case Points: {
                return bufSize;
            }
            case Lines: {
                return bufSize / 2;
            }
            case LineLoop: {
                return bufSize;
            }
            case LineStrip: {
                return bufSize - 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void updateCounts() {
        if (this.getBuffer(VertexBuffer.Type.InterleavedData) != null) {
            throw new IllegalStateException("Should update counts before interleave");
        }
        VertexBuffer pb = this.getBuffer(VertexBuffer.Type.Position);
        VertexBuffer ib = this.getBuffer(VertexBuffer.Type.Index);
        if (pb != null) {
            this.vertCount = pb.getData().capacity() / pb.getNumComponents();
        }
        this.elementCount = ib != null ? this.computeNumElements(ib.getData().capacity()) : this.computeNumElements(this.vertCount);
    }

    public int getTriangleCount(int lod) {
        if (this.lodLevels != null) {
            if (lod < 0) {
                throw new IllegalArgumentException("LOD level cannot be < 0");
            }
            if (lod >= this.lodLevels.length) {
                throw new IllegalArgumentException("LOD level " + lod + " does not exist!");
            }
            return this.computeNumElements(this.lodLevels[lod].getData().capacity());
        }
        if (lod == 0) {
            return this.elementCount;
        }
        throw new IllegalArgumentException("There are no LOD levels on the mesh!");
    }

    public int getTriangleCount() {
        return this.elementCount;
    }

    public int getVertexCount() {
        return this.vertCount;
    }

    public void getTriangle(int index, Vector3f v1, Vector3f v2, Vector3f v3) {
        VertexBuffer pb = this.getBuffer(VertexBuffer.Type.Position);
        IndexBuffer ib = this.getIndicesAsList();
        if (pb == null || pb.getFormat() != VertexBuffer.Format.Float || pb.getNumComponents() != 3) {
            throw new UnsupportedOperationException("Position buffer not set or  has incompatible format");
        }
        FloatBuffer fpb = (FloatBuffer)pb.getData();
        int vertIndex = index * 3;
        int vert1 = ib.get(vertIndex);
        int vert2 = ib.get(vertIndex + 1);
        int vert3 = ib.get(vertIndex + 2);
        BufferUtils.populateFromBuffer(v1, fpb, vert1);
        BufferUtils.populateFromBuffer(v2, fpb, vert2);
        BufferUtils.populateFromBuffer(v3, fpb, vert3);
    }

    public void getTriangle(int index, Triangle tri) {
        this.getTriangle(index, tri.get1(), tri.get2(), tri.get3());
        tri.setIndex(index);
        tri.setNormal(null);
    }

    public void getTriangle(int index, int[] indices) {
        IndexBuffer ib = this.getIndicesAsList();
        int vertIndex = index * 3;
        indices[0] = ib.get(vertIndex);
        indices[1] = ib.get(vertIndex + 1);
        indices[2] = ib.get(vertIndex + 2);
    }

    public int getId() {
        return this.vertexArrayID;
    }

    public void setId(int id) {
        if (this.vertexArrayID != -1) {
            throw new IllegalStateException("ID has already been set.");
        }
        this.vertexArrayID = id;
    }

    public void createCollisionData() {
        BIHTree tree = new BIHTree(this);
        tree.construct();
        this.collisionTree = tree;
    }

    public int collideWith(Collidable other, Matrix4f worldMatrix, BoundingVolume worldBound, CollisionResults results) {
        if (this.collisionTree == null) {
            this.createCollisionData();
        }
        return this.collisionTree.collideWith(other, worldMatrix, worldBound, results);
    }

    public void setBuffer(VertexBuffer.Type type, int components, FloatBuffer buf) {
        VertexBuffer vb = this.buffers.get(type.ordinal());
        if (vb == null) {
            if (buf == null) {
                return;
            }
            vb = new VertexBuffer(type);
            vb.setupData(VertexBuffer.Usage.Dynamic, components, VertexBuffer.Format.Float, buf);
            this.buffers.put(type.ordinal(), vb);
            this.buffersList.add(vb);
        } else {
            vb.setupData(VertexBuffer.Usage.Dynamic, components, VertexBuffer.Format.Float, buf);
        }
        this.updateCounts();
    }

    public void setBuffer(VertexBuffer.Type type, int components, float[] buf) {
        this.setBuffer(type, components, BufferUtils.createFloatBuffer(buf));
    }

    public void setBuffer(VertexBuffer.Type type, int components, IntBuffer buf) {
        VertexBuffer vb = this.buffers.get(type.ordinal());
        if (vb == null) {
            vb = new VertexBuffer(type);
            vb.setupData(VertexBuffer.Usage.Dynamic, components, VertexBuffer.Format.UnsignedInt, buf);
            this.buffers.put(type.ordinal(), vb);
            this.buffersList.add(vb);
            this.updateCounts();
        }
    }

    public void setBuffer(VertexBuffer.Type type, int components, int[] buf) {
        this.setBuffer(type, components, BufferUtils.createIntBuffer(buf));
    }

    public void setBuffer(VertexBuffer.Type type, int components, ShortBuffer buf) {
        VertexBuffer vb = this.buffers.get(type.ordinal());
        if (vb == null) {
            vb = new VertexBuffer(type);
            vb.setupData(VertexBuffer.Usage.Dynamic, components, VertexBuffer.Format.UnsignedShort, buf);
            this.buffers.put(type.ordinal(), vb);
            this.buffersList.add(vb);
            this.updateCounts();
        }
    }

    public void setBuffer(VertexBuffer.Type type, int components, byte[] buf) {
        this.setBuffer(type, components, BufferUtils.createByteBuffer(buf));
    }

    public void setBuffer(VertexBuffer.Type type, int components, ByteBuffer buf) {
        VertexBuffer vb = this.buffers.get(type.ordinal());
        if (vb == null) {
            vb = new VertexBuffer(type);
            vb.setupData(VertexBuffer.Usage.Dynamic, components, VertexBuffer.Format.UnsignedByte, buf);
            this.buffers.put(type.ordinal(), vb);
            this.buffersList.add(vb);
            this.updateCounts();
        }
    }

    public void setBuffer(VertexBuffer vb) {
        if (this.buffers.containsKey(vb.getBufferType().ordinal())) {
            throw new IllegalArgumentException("Buffer type already set: " + (Object)((Object)vb.getBufferType()));
        }
        this.buffers.put(vb.getBufferType().ordinal(), vb);
        this.buffersList.add(vb);
        this.updateCounts();
    }

    public void clearBuffer(VertexBuffer.Type type) {
        VertexBuffer vb = this.buffers.remove(type.ordinal());
        if (vb != null) {
            this.buffersList.remove(vb);
            this.updateCounts();
        }
    }

    public void setBuffer(VertexBuffer.Type type, int components, short[] buf) {
        this.setBuffer(type, components, BufferUtils.createShortBuffer(buf));
    }

    public VertexBuffer getBuffer(VertexBuffer.Type type) {
        return this.buffers.get(type.ordinal());
    }

    public FloatBuffer getFloatBuffer(VertexBuffer.Type type) {
        VertexBuffer vb = this.getBuffer(type);
        if (vb == null) {
            return null;
        }
        return (FloatBuffer)vb.getData();
    }

    public ShortBuffer getShortBuffer(VertexBuffer.Type type) {
        VertexBuffer vb = this.getBuffer(type);
        if (vb == null) {
            return null;
        }
        return (ShortBuffer)vb.getData();
    }

    public IndexBuffer getIndicesAsList() {
        if (this.mode == Mode.Hybrid) {
            throw new UnsupportedOperationException("Hybrid mode not supported");
        }
        IndexBuffer ib = this.getIndexBuffer();
        if (ib != null) {
            if (this.mode.isListMode()) {
                return ib;
            }
            return new WrappedIndexBuffer(this);
        }
        return new VirtualIndexBuffer(this.vertCount, this.mode);
    }

    public IndexBuffer getIndexBuffer() {
        VertexBuffer vb = this.getBuffer(VertexBuffer.Type.Index);
        if (vb == null) {
            return null;
        }
        Buffer buf = vb.getData();
        if (buf instanceof ByteBuffer) {
            return new IndexByteBuffer((ByteBuffer)buf);
        }
        if (buf instanceof ShortBuffer) {
            return new IndexShortBuffer((ShortBuffer)buf);
        }
        if (buf instanceof IntBuffer) {
            return new IndexIntBuffer((IntBuffer)buf);
        }
        throw new UnsupportedOperationException("Index buffer type unsupported: " + buf.getClass());
    }

    public void scaleTextureCoordinates(Vector2f scaleFactor) {
        VertexBuffer tc = this.getBuffer(VertexBuffer.Type.TexCoord);
        if (tc == null) {
            throw new IllegalStateException("The mesh has no texture coordinates");
        }
        if (tc.getFormat() != VertexBuffer.Format.Float) {
            throw new UnsupportedOperationException("Only float texture coord format is supported");
        }
        if (tc.getNumComponents() != 2) {
            throw new UnsupportedOperationException("Only 2D texture coords are supported");
        }
        FloatBuffer fb = (FloatBuffer)tc.getData();
        fb.clear();
        for (int i = 0; i < fb.capacity() / 2; ++i) {
            float x = fb.get();
            float y = fb.get();
            fb.position(fb.position() - 2);
            fb.put(x *= scaleFactor.getX()).put(y *= scaleFactor.getY());
        }
        fb.clear();
        tc.updateData(fb);
    }

    public void updateBound() {
        VertexBuffer posBuf = this.getBuffer(VertexBuffer.Type.Position);
        if (this.meshBound != null && posBuf != null) {
            this.meshBound.computeFromPoints((FloatBuffer)posBuf.getData());
        }
    }

    public BoundingVolume getBound() {
        return this.meshBound;
    }

    public void setBound(BoundingVolume modelBound) {
        this.meshBound = modelBound;
    }

    public IntMap<VertexBuffer> getBuffers() {
        return this.buffers;
    }

    public ArrayList<VertexBuffer> getBufferList() {
        return this.buffersList;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.meshBound, "modelBound", null);
        out.write(this.vertCount, "vertCount", -1);
        out.write(this.elementCount, "elementCount", -1);
        out.write(this.maxNumWeights, "max_num_weights", -1);
        out.write(this.mode, "mode", Mode.Triangles);
        out.write(this.collisionTree, "collisionTree", null);
        out.write(this.elementLengths, "elementLengths", (int[])null);
        out.write(this.modeStart, "modeStart", (int[])null);
        out.write(this.pointSize, "pointSize", 1.0f);
        out.writeIntSavableMap(this.buffers, "buffers", null);
        out.write(this.lodLevels, "lodLevels", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.meshBound = (BoundingVolume)in.readSavable("modelBound", null);
        this.vertCount = in.readInt("vertCount", -1);
        this.elementCount = in.readInt("elementCount", -1);
        this.maxNumWeights = in.readInt("max_num_weights", -1);
        this.mode = in.readEnum("mode", Mode.class, Mode.Triangles);
        this.elementLengths = in.readIntArray("elementLengths", null);
        this.modeStart = in.readIntArray("modeStart", null);
        this.collisionTree = (BIHTree)in.readSavable("collisionTree", null);
        this.elementLengths = in.readIntArray("elementLengths", null);
        this.modeStart = in.readIntArray("modeStart", null);
        this.pointSize = in.readFloat("pointSize", 1.0f);
        this.buffers = in.readIntSavableMap("buffers", null);
        for (IntMap.Entry<VertexBuffer> entry : this.buffers) {
            this.buffersList.add(entry.getValue());
        }
        Savable[] lodLevelsSavable = in.readSavableArray("lodLevels", null);
        if (lodLevelsSavable != null) {
            this.lodLevels = new VertexBuffer[lodLevelsSavable.length];
            System.arraycopy(lodLevelsSavable, 0, this.lodLevels, 0, this.lodLevels.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        Points(true),
        Lines(true),
        LineStrip(false),
        LineLoop(false),
        Triangles(true),
        TriangleStrip(false),
        TriangleFan(false),
        Hybrid(false);

        private boolean listMode = false;

        private Mode(boolean listMode) {
            this.listMode = listMode;
        }

        public boolean isListMode() {
            return this.listMode;
        }
    }
}

