/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;

public class DepthOfFieldFilter
extends Filter {
    private float focusDistance = 50.0f;
    private float focusRange = 10.0f;
    private float blurScale = 1.0f;
    private float xScale;
    private float yScale;

    public DepthOfFieldFilter() {
        super("Depth Of Field");
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected Material getMaterial() {
        return this.material;
    }

    protected void initFilter(AssetManager assets, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(assets, "Common/MatDefs/Post/DepthOfField.j3md");
        this.material.setFloat("FocusDistance", this.focusDistance);
        this.material.setFloat("FocusRange", this.focusRange);
        this.xScale = 1.0f / (float)w;
        this.yScale = 1.0f / (float)h;
        this.material.setFloat("XScale", this.blurScale * this.xScale);
        this.material.setFloat("YScale", this.blurScale * this.yScale);
    }

    public void setFocusDistance(float f) {
        this.focusDistance = f;
        if (this.material != null) {
            this.material.setFloat("FocusDistance", this.focusDistance);
        }
    }

    public float getFocusDistance() {
        return this.focusDistance;
    }

    public void setFocusRange(float f) {
        this.focusRange = f;
        if (this.material != null) {
            this.material.setFloat("FocusRange", this.focusRange);
        }
    }

    public float getFocusRange() {
        return this.focusRange;
    }

    public void setBlurScale(float f) {
        this.blurScale = f;
        if (this.material != null) {
            this.material.setFloat("XScale", this.blurScale * this.xScale);
            this.material.setFloat("YScale", this.blurScale * this.yScale);
        }
    }

    public float getBlurScale() {
        return this.blurScale;
    }
}

