/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.connection;

import com.jme3.network.connection.Client;
import com.jme3.network.connection.Connection;
import com.jme3.network.message.Message;
import com.jme3.network.queue.MessageQueue;
import com.jme3.network.serializing.Serializer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class TCPConnection
extends Connection {
    protected SocketChannel socketChannel;
    protected ServerSocketChannel serverSocketChannel;
    protected ByteBuffer readBuffer;
    protected ByteBuffer writeBuffer;
    protected ByteBuffer tempWriteBuffer;
    protected final Object writeLock = new Object();
    private int objectLength = 0;

    public TCPConnection(String name) {
        this.label = name;
        this.readBuffer = ByteBuffer.allocateDirect(16228);
        this.writeBuffer = ByteBuffer.allocateDirect(16228);
        this.tempWriteBuffer = ByteBuffer.allocateDirect(16228);
    }

    public TCPConnection() {
    }

    public void connect(SocketAddress address) throws IOException {
        this.socketChannel = SocketChannel.open();
        this.socketChannel.socket().setTcpNoDelay(true);
        this.socketChannel.configureBlocking(false);
        this.socketChannel.connect(address);
        this.socketChannel.register(this.selector, 8).attach(this);
        this.log.log(Level.INFO, "[{1}][TCP] Connecting to {0}", new Object[]{address, this.label});
    }

    public void bind(SocketAddress address) throws IOException {
        this.serverSocketChannel = this.selector.provider().openServerSocketChannel();
        this.serverSocketChannel.socket().bind(address);
        this.serverSocketChannel.configureBlocking(false);
        this.serverSocketChannel.register(this.selector, 16);
        this.log.log(Level.INFO, "[{1}][TCP] Bound to {0}", new Object[]{address, this.label});
    }

    public void connect(SelectableChannel channel) throws IOException {
        ((SocketChannel)channel).finishConnect();
        this.socketChannel.keyFor(this.selector).interestOps(5);
        this.fireClientConnected(null);
        this.log.log(Level.INFO, "[{0}][TCP] Connection succeeded.", this.label);
    }

    public void accept(SelectableChannel channel) throws IOException {
        SocketChannel socketChannel = ((ServerSocketChannel)channel).accept();
        String reason = this.shouldFilterConnector((InetSocketAddress)socketChannel.socket().getRemoteSocketAddress());
        if (reason != null) {
            this.log.log(Level.INFO, "[{2}][TCP] Client with address {0} got filtered with reason: {1}", new Object[]{(InetSocketAddress)socketChannel.socket().getRemoteSocketAddress(), reason, this.label});
            socketChannel.close();
            return;
        }
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        Client con = new Client(true);
        con.setTCPConnection(this);
        con.setSocketChannel(socketChannel);
        socketChannel.register(this.selector, 1, con);
        this.connections.add(con);
        this.log.log(Level.INFO, "[{1}][TCP] A client connected with address {0}", new Object[]{socketChannel.socket().getInetAddress(), this.label});
    }

    public void read(SelectableChannel channel) throws IOException {
        SocketChannel socketChannel = (SocketChannel)channel;
        if (socketChannel == null) {
            this.log.log(Level.WARNING, "[{0}][TCP] Connection was closed before we could read.", this.label);
            return;
        }
        int read = -1;
        this.readBuffer.compact();
        try {
            read = socketChannel.read(this.readBuffer);
        }
        catch (IOException ioe) {
            socketChannel.keyFor(this.selector).cancel();
            if (this.serverSocketChannel != null) {
                this.log.log(Level.WARNING, "[{0}][TCP] Connection was forcibly closed before we could read. Disconnected client.", this.label);
                this.addToDisconnectionQueue((Client)socketChannel.keyFor(this.selector).attachment());
            }
            this.log.log(Level.WARNING, "[{0}][TCP] Server forcibly closed connection. Disconnected.", this.label);
            this.fireClientDisconnected(null);
        }
        if (read != -1) {
            this.log.log(Level.FINE, "[{1}][TCP] Read {0} bytes.", new Object[]{read, this.label});
        }
        this.readBuffer.flip();
        if (read == -1) {
            socketChannel.keyFor(this.selector).cancel();
            if (this.serverSocketChannel != null) {
                this.log.log(Level.WARNING, "[{0}][TCP] Connection was closed before we could read. Disconnected client.", this.label);
                this.addToDisconnectionQueue((Client)socketChannel.keyFor(this.selector).attachment());
            } else {
                this.log.log(Level.WARNING, "[{0}][TCP] Server closed connection. Disconnected.", this.label);
                this.fireClientDisconnected(null);
            }
            return;
        }
        try {
            while (true) {
                if (this.objectLength == 0) {
                    this.objectLength = this.readBuffer.getShort();
                }
                int pos = this.readBuffer.position();
                int oldLimit = this.readBuffer.limit();
                int dataLength = this.objectLength;
                if (dataLength > 0 && this.readBuffer.remaining() >= dataLength) {
                    if (pos + dataLength + 2 > this.readBuffer.capacity()) {
                        this.readBuffer.limit(this.readBuffer.capacity());
                    } else {
                        this.readBuffer.limit(pos + dataLength + 2);
                    }
                    Object obj = Serializer.readClassAndObject(this.readBuffer);
                    this.readBuffer.limit(oldLimit);
                    this.objectLength = 0;
                    if (obj == null) continue;
                    if (obj instanceof Message) {
                        Message message = (Message)obj;
                        Object attachment = socketChannel.keyFor(this.selector).attachment();
                        if (attachment instanceof Client) {
                            message.setClient((Client)attachment);
                        }
                        message.setConnection(this);
                        this.fireMessageReceived(message);
                    } else {
                        this.fireObjectReceived(obj);
                    }
                    this.log.log(Level.FINEST, "[{0}][TCP] Read full object: {1}", new Object[]{this.label, obj});
                    continue;
                }
                if (dataLength > this.readBuffer.remaining()) {
                    this.readBuffer.compact();
                    int bytesRead = socketChannel.read(this.readBuffer);
                    this.log.log(Level.FINEST, "[{0}][TCP] Object won't fit in buffer, so read {1} more bytes in a compacted buffer.", new Object[]{this.label, bytesRead});
                    this.readBuffer.flip();
                    continue;
                }
                this.objectLength = dataLength;
            }
        }
        catch (BufferUnderflowException someEx) {
            this.log.log(Level.FINEST, "[{0}][TCP] Done reading messages.", new Object[]{this.label});
            return;
        }
    }

    public void sendObject(Object object) throws IOException {
        if (this.serverSocketChannel == null) {
            this.send(this.socketChannel, object);
        } else {
            for (Client connector : this.connections) {
                this.send(connector.getSocketChannel(), object);
            }
        }
    }

    public void sendObject(Client con, Object object) throws IOException {
        if (object instanceof Message) {
            ((Message)object).setClient(con);
        }
        this.send(con.getSocketChannel(), object);
    }

    public void cleanup() throws IOException {
        if (this.serverSocketChannel != null) {
            this.serverSocketChannel.close();
            this.connections.clear();
        } else {
            this.socketChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(SocketChannel channel, Object object) throws IOException {
        try {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.tempWriteBuffer.clear();
                this.tempWriteBuffer.position(4);
                Serializer.writeClassAndObject(this.tempWriteBuffer, object);
                this.tempWriteBuffer.flip();
                int dataLength = this.tempWriteBuffer.limit() - 4;
                this.tempWriteBuffer.position(0);
                this.tempWriteBuffer.putInt(dataLength);
                this.tempWriteBuffer.position(0);
                if (dataLength > this.writeBuffer.capacity()) {
                    this.log.log(Level.WARNING, "[{0}][TCP] Message too big for buffer. Discarded.", this.label);
                    return;
                }
                if (this.writeBuffer.position() > 0) {
                    try {
                        this.writeBuffer.put(this.tempWriteBuffer);
                    }
                    catch (BufferOverflowException boe) {
                        this.log.log(Level.WARNING, "[{0}][TCP] Buffer overflow occurred while appending data to be sent later. Cleared the buffer, so some data may be lost.", this.label);
                        this.writeBuffer.clear();
                        while (this.tempWriteBuffer.hasRemaining()) {
                            if (channel.write(this.tempWriteBuffer) != 0) continue;
                        }
                    }
                    {
                        break;
                    }
                }
                int writeLength = 0;
                while (this.tempWriteBuffer.hasRemaining()) {
                    int wrote = channel.write(this.tempWriteBuffer);
                    writeLength += wrote;
                    if (wrote != 0) continue;
                    break;
                }
                this.log.log(Level.FINE, "[{1}][TCP] Wrote {0} bytes.", new Object[]{writeLength, this.label});
                try {
                    if (this.writeBuffer.hasRemaining()) {
                        this.writeBuffer.put(this.tempWriteBuffer);
                        channel.keyFor(this.selector).interestOps(5);
                    } else if (object instanceof Message) {
                        this.fireMessageSent((Message)object);
                    } else {
                        this.fireObjectSent(object);
                    }
                }
                catch (BufferOverflowException boe) {
                    this.log.log(Level.WARNING, "[{0}][TCP] Buffer overflow occurred while queuing data to be sent later. Cleared the buffer, so some data may be lost. Please note that this exception occurs rarely, so if this is shown often, please check your message sizes or contact the developer.", this.label);
                    this.writeBuffer.clear();
                }
            }
        }
        catch (IOException ioe) {
            Client client = this.socketChannel == null ? ((Message)object).getClient() : (Client)this.socketChannel.keyFor(this.selector).attachment();
            if (client != null) {
                this.addToDisconnectionQueue(client);
                this.log.log(Level.WARNING, "[{0}][TCP] Disconnected {1} because an error occurred: {2}.", new Object[]{this.label, client, ioe.getMessage()});
                return;
            }
            throw ioe;
        }
    }

    public synchronized void write(SelectableChannel channel) throws IOException {
        SocketChannel socketChannel = (SocketChannel)channel;
        Client client = (Client)socketChannel.keyFor(this.selector).attachment();
        MessageQueue queue = client.getMessageQueue();
        LinkedHashMap<Message, Short> sizeMap = new LinkedHashMap<Message, Short>();
        Iterator it = queue.iterator();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            if (!message.isReliable()) continue;
            int pos = this.writeBuffer.position();
            try {
                this.writeBuffer.position(pos + 2);
                Serializer.writeClassAndObject(this.writeBuffer, message);
                short dataLength = (short)(this.writeBuffer.position() - pos - 2);
                this.writeBuffer.position(pos);
                this.writeBuffer.putShort(dataLength);
                this.writeBuffer.position(pos + dataLength + 2);
                sizeMap.put(message, dataLength);
                it.remove();
            }
            catch (Exception bfe) {
                this.writeBuffer.position(pos);
                break;
            }
        }
        this.writeBuffer.flip();
        int written = 0;
        while (this.writeBuffer.hasRemaining()) {
            int wrote = socketChannel.write(this.writeBuffer);
            written += wrote;
            if (wrote != 0) continue;
            break;
        }
        this.log.log(Level.FINE, "[{1}][TCP] Wrote {0} bytes.", new Object[]{written, this.label});
        if (this.writeBuffer.hasRemaining()) {
            Iterator it2 = sizeMap.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                if ((written -= ((Short)entry.getValue()).shortValue()) > 0) {
                    it2.remove();
                    continue;
                }
                client.getMessageQueue().add(entry.getKey());
            }
        }
        if (queue.isEmpty()) {
            channel.keyFor(this.selector).interestOps(1);
        }
        this.writeBuffer.clear();
    }
}

