/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.system.JmeSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;

public class ClasspathLocator
implements AssetLocator {
    private static final Logger logger = Logger.getLogger(ClasspathLocator.class.getName());
    private String root = "";

    public void setRootPath(String rootPath) {
        this.root = rootPath;
        if (this.root.equals("/")) {
            this.root = "";
        } else if (this.root.length() > 1) {
            if (this.root.startsWith("/")) {
                this.root = this.root.substring(1);
            }
            if (!this.root.endsWith("/")) {
                this.root = this.root + "/";
            }
        }
    }

    public AssetInfo locate(AssetManager manager, AssetKey key) {
        String name = key.getName();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        name = this.root + name;
        URL url = JmeSystem.isLowPermissions() ? ClasspathLocator.class.getResource("/" + name) : Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file")) {
            try {
                String path = new File(url.toURI()).getCanonicalPath();
                if (File.separatorChar == '\\') {
                    path = path.replace('\\', '/');
                }
                if (!path.endsWith(name)) {
                    throw new AssetNotFoundException("Asset name doesn't match requirements.\n\"" + path + "\" doesn't match \"" + name + "\"");
                }
            }
            catch (URISyntaxException ex) {
                throw new AssetLoadException("Error converting URL to URI", ex);
            }
            catch (IOException ex) {
                throw new AssetLoadException("Failed to get canonical path for " + url, ex);
            }
        }
        try {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            return new ClasspathAssetInfo(manager, key, conn);
        }
        catch (IOException ex) {
            throw new AssetLoadException("Failed to read URL " + url, ex);
        }
    }

    private static class ClasspathAssetInfo
    extends AssetInfo {
        private URLConnection conn;

        public ClasspathAssetInfo(AssetManager manager, AssetKey key, URLConnection conn) {
            super(manager, key);
            this.conn = conn;
        }

        public InputStream openStream() {
            try {
                return this.conn.getInputStream();
            }
            catch (IOException ex) {
                return null;
            }
        }
    }
}

