/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.Platform;
import java.nio.ByteBuffer;
import jogamp.nativewindow.windows.BITMAPINFO32;
import jogamp.nativewindow.windows.BITMAPINFO64;
import jogamp.nativewindow.windows.BITMAPINFOHEADER;

public abstract class BITMAPINFO {
    StructAccessor accessor;

    public static int size() {
        if (Platform.is32Bit()) {
            return BITMAPINFO32.size();
        }
        return BITMAPINFO64.size();
    }

    public static BITMAPINFO create() {
        return BITMAPINFO.create(Buffers.newDirectByteBuffer((int)BITMAPINFO.size()));
    }

    public static BITMAPINFO create(ByteBuffer byteBuffer) {
        if (Platform.is32Bit()) {
            return new BITMAPINFO32(byteBuffer);
        }
        return new BITMAPINFO64(byteBuffer);
    }

    BITMAPINFO(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public abstract BITMAPINFOHEADER getBmiHeader();
}

