/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.math.Matrix3f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.TerrainQuad;
import java.util.LinkedList;

public class CollisionShapeFactory {
    private static Transform getTransform(Spatial spatial, Spatial spatial2) {
        Transform transform = new Transform();
        Spatial spatial3 = spatial.getParent() != null ? spatial.getParent() : spatial;
        Spatial spatial4 = spatial;
        while (spatial3 != null) {
            if (spatial2 == spatial4) {
                Transform transform2 = new Transform();
                transform2.setScale(spatial4.getLocalScale());
                transform.combineWithParent(transform2);
                spatial3 = null;
                continue;
            }
            transform.combineWithParent(spatial4.getLocalTransform());
            spatial4 = spatial3 = spatial4.getParent();
        }
        return transform;
    }

    private static CompoundCollisionShape createCompoundShape(Node node, Node node2, CompoundCollisionShape compoundCollisionShape, boolean bl, boolean bl2) {
        for (Spatial spatial : node2.getChildren()) {
            Object object;
            Boolean bl3;
            if (spatial instanceof Node) {
                CollisionShapeFactory.createCompoundShape(node, (Node)spatial, compoundCollisionShape, bl, bl2);
                continue;
            }
            if (!(spatial instanceof Geometry) || (bl3 = (Boolean)spatial.getUserData("JmePhysicsIgnore")) != null && bl3.booleanValue()) continue;
            if (bl) {
                object = bl2 ? CollisionShapeFactory.createSingleDynamicMeshShape((Geometry)spatial, (Spatial)node) : CollisionShapeFactory.createSingleMeshShape((Geometry)spatial, (Spatial)node);
                if (object == null) continue;
                Transform transform = CollisionShapeFactory.getTransform(spatial, (Spatial)node);
                compoundCollisionShape.addChildShape((CollisionShape)object, transform.getTranslation(), transform.getRotation().toRotationMatrix());
                continue;
            }
            object = CollisionShapeFactory.getTransform(spatial, (Spatial)node);
            compoundCollisionShape.addChildShape(CollisionShapeFactory.createSingleBoxShape(spatial, (Spatial)node), object.getTranslation(), object.getRotation().toRotationMatrix());
        }
        return compoundCollisionShape;
    }

    private static CompoundCollisionShape createCompoundShape(Node node, CompoundCollisionShape compoundCollisionShape, boolean bl) {
        return CollisionShapeFactory.createCompoundShape(node, node, compoundCollisionShape, bl, false);
    }

    private static CompoundCollisionShape createMeshCompoundShape(Node node) {
        return CollisionShapeFactory.createCompoundShape(node, new CompoundCollisionShape(), true);
    }

    private static CompoundCollisionShape createBoxCompoundShape(Node node) {
        return CollisionShapeFactory.createCompoundShape(node, new CompoundCollisionShape(), false);
    }

    public static CollisionShape createMeshShape(Spatial spatial) {
        if (spatial instanceof TerrainQuad) {
            TerrainQuad terrainQuad = (TerrainQuad)spatial;
            return new HeightfieldCollisionShape(terrainQuad.getHeightMap(), terrainQuad.getLocalScale());
        }
        if (spatial instanceof TerrainPatch) {
            TerrainPatch terrainPatch = (TerrainPatch)spatial;
            return new HeightfieldCollisionShape(terrainPatch.getHeightmap().array(), terrainPatch.getLocalScale());
        }
        if (spatial instanceof Geometry) {
            return CollisionShapeFactory.createSingleMeshShape((Geometry)spatial, spatial);
        }
        if (spatial instanceof Node) {
            return CollisionShapeFactory.createMeshCompoundShape((Node)spatial);
        }
        throw new IllegalArgumentException("Supplied spatial must either be Node or Geometry!");
    }

    public static CollisionShape createDynamicMeshShape(Spatial spatial) {
        if (spatial instanceof Geometry) {
            return CollisionShapeFactory.createSingleDynamicMeshShape((Geometry)spatial, spatial);
        }
        if (spatial instanceof Node) {
            return CollisionShapeFactory.createCompoundShape((Node)spatial, (Node)spatial, new CompoundCollisionShape(), true, true);
        }
        throw new IllegalArgumentException("Supplied spatial must either be Node or Geometry!");
    }

    public static CollisionShape createBoxShape(Spatial spatial) {
        if (spatial instanceof Geometry) {
            return CollisionShapeFactory.createSingleBoxShape((Spatial)((Geometry)spatial), spatial);
        }
        if (spatial instanceof Node) {
            return CollisionShapeFactory.createBoxCompoundShape((Node)spatial);
        }
        throw new IllegalArgumentException("Supplied spatial must either be Node or Geometry!");
    }

    private static MeshCollisionShape createSingleMeshShape(Geometry geometry, Spatial spatial) {
        Mesh mesh = geometry.getMesh();
        Transform transform = CollisionShapeFactory.getTransform((Spatial)geometry, spatial);
        if (mesh != null) {
            MeshCollisionShape meshCollisionShape = new MeshCollisionShape(mesh);
            meshCollisionShape.setScale(transform.getScale());
            return meshCollisionShape;
        }
        return null;
    }

    private static BoxCollisionShape createSingleBoxShape(Spatial spatial, Spatial spatial2) {
        spatial.setModelBound((BoundingVolume)new BoundingBox());
        BoxCollisionShape boxCollisionShape = new BoxCollisionShape(((BoundingBox)spatial.getWorldBound()).getExtent(new Vector3f()));
        return boxCollisionShape;
    }

    private static HullCollisionShape createSingleDynamicMeshShape(Geometry geometry, Spatial spatial) {
        Mesh mesh = geometry.getMesh();
        Transform transform = CollisionShapeFactory.getTransform((Spatial)geometry, spatial);
        if (mesh != null) {
            HullCollisionShape hullCollisionShape = new HullCollisionShape(mesh);
            hullCollisionShape.setScale(transform.getScale());
            return hullCollisionShape;
        }
        return null;
    }

    public static void shiftCompoundShapeContents(CompoundCollisionShape compoundCollisionShape, Vector3f vector3f) {
        for (ChildCollisionShape childCollisionShape : new LinkedList<ChildCollisionShape>(compoundCollisionShape.getChildren())) {
            CollisionShape collisionShape = childCollisionShape.shape;
            Vector3f vector3f2 = childCollisionShape.location;
            Matrix3f matrix3f = childCollisionShape.rotation;
            compoundCollisionShape.removeChildShape(collisionShape);
            compoundCollisionShape.addChildShape(collisionShape, vector3f2.add(vector3f), matrix3f);
        }
    }
}

