/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.MatchException;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.text.MaximumCapacityPatternCache;
import com.jeantessier.text.RegularExpressionParser;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.perl.Perl5Util;

public class RegularExpressionSelectionCriteria
implements SelectionCriteria {
    private Perl5Util perl = new Perl5Util((PatternCache)new MaximumCapacityPatternCache());
    private List<String> globalIncludes = new LinkedList<String>();
    private List<String> globalExcludes = new LinkedList<String>();
    private boolean matchingPackages = true;
    private List<String> packageIncludes = new LinkedList<String>();
    private List<String> packageExcludes = new LinkedList<String>();
    private boolean matchingClasses = true;
    private List<String> classIncludes = new LinkedList<String>();
    private List<String> classExcludes = new LinkedList<String>();
    private boolean matchingFeatures = true;
    private List<String> featureIncludes = new LinkedList<String>();
    private List<String> featureExcludes = new LinkedList<String>();

    public RegularExpressionSelectionCriteria() {
    }

    public RegularExpressionSelectionCriteria(String initialGlobalIncludes) {
        this.setGlobalIncludes(initialGlobalIncludes);
    }

    public List<String> getGlobalIncludes() {
        return this.globalIncludes;
    }

    public void setGlobalIncludes(String globalIncludes) {
        this.setGlobalIncludes(RegularExpressionParser.parseRE(globalIncludes));
    }

    public void setGlobalIncludes(List<String> globalIncludes) {
        this.globalIncludes = globalIncludes;
    }

    public List<String> getGlobalExcludes() {
        return this.globalExcludes;
    }

    public void setGlobalExcludes(String globalExcludes) {
        this.setGlobalExcludes(RegularExpressionParser.parseRE(globalExcludes));
    }

    public void setGlobalExcludes(List<String> globalExcludes) {
        this.globalExcludes = globalExcludes;
    }

    @Override
    public boolean isMatchingPackages() {
        return this.matchingPackages;
    }

    public void setMatchingPackages(boolean matchingPackages) {
        this.matchingPackages = matchingPackages;
    }

    public List<String> getPackageIncludes() {
        return this.packageIncludes;
    }

    public void setPackageIncludes(String packageIncludes) {
        this.setPackageIncludes(RegularExpressionParser.parseRE(packageIncludes));
    }

    public void setPackageIncludes(List<String> packageIncludes) {
        this.packageIncludes = packageIncludes;
    }

    public List<String> getPackageExcludes() {
        return this.packageExcludes;
    }

    public void setPackageExcludes(String packageExcludes) {
        this.setPackageExcludes(RegularExpressionParser.parseRE(packageExcludes));
    }

    public void setPackageExcludes(List<String> packageExcludes) {
        this.packageExcludes = packageExcludes;
    }

    @Override
    public boolean isMatchingClasses() {
        return this.matchingClasses;
    }

    public void setMatchingClasses(boolean matchingClasses) {
        this.matchingClasses = matchingClasses;
    }

    public List<String> getClassIncludes() {
        return this.classIncludes;
    }

    public void setClassIncludes(String classIncludes) {
        this.setClassIncludes(RegularExpressionParser.parseRE(classIncludes));
    }

    public void setClassIncludes(List<String> classIncludes) {
        this.classIncludes = classIncludes;
    }

    public List<String> getClassExcludes() {
        return this.classExcludes;
    }

    public void setClassExcludes(String classExcludes) {
        this.setClassExcludes(RegularExpressionParser.parseRE(classExcludes));
    }

    public void setClassExcludes(List<String> classExcludes) {
        this.classExcludes = classExcludes;
    }

    @Override
    public boolean isMatchingFeatures() {
        return this.matchingFeatures;
    }

    public void setMatchingFeatures(boolean matchingFeatures) {
        this.matchingFeatures = matchingFeatures;
    }

    public List<String> getFeatureIncludes() {
        return this.featureIncludes;
    }

    public void setFeatureIncludes(String featureIncludes) {
        this.setFeatureIncludes(RegularExpressionParser.parseRE(featureIncludes));
    }

    public void setFeatureIncludes(List<String> featureIncludes) {
        this.featureIncludes = featureIncludes;
    }

    public List<String> getFeatureExcludes() {
        return this.featureExcludes;
    }

    public void setFeatureExcludes(String featureExcludes) {
        this.setFeatureExcludes(RegularExpressionParser.parseRE(featureExcludes));
    }

    public void setFeatureExcludes(List<String> featureExcludes) {
        this.featureExcludes = featureExcludes;
    }

    @Override
    public boolean matches(PackageNode node) {
        return this.isMatchingPackages() && this.matchesPackageName(node.getName());
    }

    @Override
    public boolean matches(ClassNode node) {
        return this.isMatchingClasses() && this.matchesClassName(node.getName());
    }

    @Override
    public boolean matches(FeatureNode node) {
        return this.isMatchingFeatures() && this.matchesFeatureName(node.getName());
    }

    @Override
    public boolean matchesPackageName(String name) {
        return this.matches(this.getGlobalIncludes(), this.getPackageIncludes(), name) && !this.matches(this.getGlobalExcludes(), this.getPackageExcludes(), name);
    }

    @Override
    public boolean matchesClassName(String name) {
        return this.matches(this.getGlobalIncludes(), this.getClassIncludes(), name) && !this.matches(this.getGlobalExcludes(), this.getClassExcludes(), name);
    }

    @Override
    public boolean matchesFeatureName(String name) {
        return this.matches(this.getGlobalIncludes(), this.getFeatureIncludes(), name) && !this.matches(this.getGlobalExcludes(), this.getFeatureExcludes(), name);
    }

    private boolean matches(List<String> globalRegularExpressions, List<String> regularExpressions, String name) {
        String regex;
        boolean found = false;
        Iterator<String> i = globalRegularExpressions.iterator();
        while (!found && i.hasNext()) {
            regex = i.next();
            try {
                found = this.perl.match(regex, name);
            }
            catch (MalformedCachePatternException ex) {
                throw new MatchException(regex, ex);
            }
        }
        i = regularExpressions.iterator();
        while (!found && i.hasNext()) {
            regex = i.next();
            try {
                found = this.perl.match(regex, name);
            }
            catch (MalformedCachePatternException ex) {
                throw new MatchException(regex, ex);
            }
        }
        return found;
    }
}

