/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.MetricsGatherer;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import java.io.PrintWriter;
import java.util.Collection;

public class MetricsReport {
    private PrintWriter out;
    private boolean listingElements = false;
    private boolean chartingClassesPerPackage = false;
    private boolean chartingFeaturesPerClass = false;
    private boolean chartingInboundsPerPackage = false;
    private boolean chartingOutboundsPerPackage = false;
    private boolean chartingInboundsPerClass = false;
    private boolean chartingOutboundsPerClass = false;
    private boolean chartingInboundsPerFeature = false;
    private boolean chartingOutboundsPerFeature = false;

    public MetricsReport(PrintWriter out) {
        this.out = out;
    }

    public boolean isListingElements() {
        return this.listingElements;
    }

    public void setListingElements(boolean listingElements) {
        this.listingElements = listingElements;
    }

    public boolean isChartingClassesPerPackage() {
        return this.chartingClassesPerPackage;
    }

    public void setChartingClassesPerPackage(boolean chartingClassesPerPackage) {
        this.chartingClassesPerPackage = chartingClassesPerPackage;
    }

    public boolean isChartingFeaturesPerClass() {
        return this.chartingFeaturesPerClass;
    }

    public void setChartingFeaturesPerClass(boolean chartingFeaturesPerClass) {
        this.chartingFeaturesPerClass = chartingFeaturesPerClass;
    }

    public boolean isChartingInboundsPerPackage() {
        return this.chartingInboundsPerPackage;
    }

    public void setChartingInboundsPerPackage(boolean chartingInboundsPerPackage) {
        this.chartingInboundsPerPackage = chartingInboundsPerPackage;
    }

    public boolean isChartingOutboundsPerPackage() {
        return this.chartingOutboundsPerPackage;
    }

    public void setChartingOutboundsPerPackage(boolean chartingOutboundsPerPackage) {
        this.chartingOutboundsPerPackage = chartingOutboundsPerPackage;
    }

    public boolean isChartingInboundsPerClass() {
        return this.chartingInboundsPerClass;
    }

    public void setChartingInboundsPerClass(boolean chartingInboundsPerClass) {
        this.chartingInboundsPerClass = chartingInboundsPerClass;
    }

    public boolean isChartingOutboundsPerClass() {
        return this.chartingOutboundsPerClass;
    }

    public void setChartingOutboundsPerClass(boolean chartingOutboundsPerClass) {
        this.chartingOutboundsPerClass = chartingOutboundsPerClass;
    }

    public boolean isChartingInboundsPerFeature() {
        return this.chartingInboundsPerFeature;
    }

    public void setChartingInboundsPerFeature(boolean chartingInboundsPerFeature) {
        this.chartingInboundsPerFeature = chartingInboundsPerFeature;
    }

    public boolean isChartingOutboundsPerFeature() {
        return this.chartingOutboundsPerFeature;
    }

    public void setChartingOutboundsPerFeature(boolean chartingOutboundsPerFeature) {
        this.chartingOutboundsPerFeature = chartingOutboundsPerFeature;
    }

    public void process(MetricsGatherer metrics) {
        int nbPackages = metrics.getPackages().size();
        this.out.print(nbPackages + " package(s)");
        if (nbPackages > 0) {
            int nbConfirmedPackages = this.countConfirmedNodes(metrics.getPackages());
            this.out.print(" (" + nbConfirmedPackages + " confirmed, " + (double)nbConfirmedPackages / (double)nbPackages + ")");
        }
        this.out.println();
        if (this.isListingElements()) {
            for (PackageNode packageNode : metrics.getPackages()) {
                this.out.println("    " + packageNode);
            }
        }
        int nbClasses = metrics.getClasses().size();
        this.out.print(nbClasses + " class(es)");
        if (nbClasses > 0) {
            int nbConfirmedClasses = this.countConfirmedNodes(metrics.getClasses());
            this.out.print(" (" + nbConfirmedClasses + " confirmed, " + (double)nbConfirmedClasses / (double)nbClasses + ")");
        }
        this.out.println();
        if (this.isListingElements()) {
            for (ClassNode classNode : metrics.getClasses()) {
                this.out.println("    " + classNode);
            }
        }
        int nbFeatures = metrics.getFeatures().size();
        this.out.print(nbFeatures + " feature(s)");
        if (nbFeatures > 0) {
            int nbConfirmedFeatures = this.countConfirmedNodes(metrics.getFeatures());
            this.out.print(" (" + nbConfirmedFeatures + " confirmed, " + (double)nbConfirmedFeatures / (double)nbFeatures + ")");
        }
        this.out.println();
        if (this.isListingElements()) {
            for (FeatureNode featureNode : metrics.getFeatures()) {
                this.out.println("    " + featureNode);
            }
        }
        this.out.println();
        this.out.println(metrics.getNbOutbound() + " outbound link(s)");
        long nbOutboundPackages = metrics.getNbOutboundPackages();
        this.out.print("    " + nbOutboundPackages + " from package(s)");
        if (nbOutboundPackages > 0L && nbPackages > 0) {
            this.out.print(" (on average " + (double)nbOutboundPackages / (double)nbPackages + " per package)");
        }
        this.out.println();
        long nbOutboundClasses = metrics.getNbOutboundClasses();
        this.out.print("    " + nbOutboundClasses + " from class(es)");
        if (nbOutboundClasses > 0L && nbClasses > 0) {
            this.out.print(" (on average " + (double)nbOutboundClasses / (double)nbClasses + " per class)");
        }
        this.out.println();
        long nbOutboundFeatures = metrics.getNbOutboundFeatures();
        this.out.print("    " + nbOutboundFeatures + " from feature(s)");
        if (nbOutboundFeatures > 0L && nbFeatures > 0) {
            this.out.print(" (on average " + (double)nbOutboundFeatures / (double)nbFeatures + " per feature)");
        }
        this.out.println();
        this.out.println(metrics.getNbInbound() + " inbound link(s)");
        long nbInboundPackages = metrics.getNbInboundPackages();
        this.out.print("    " + nbInboundPackages + " to package(s)");
        if (nbInboundPackages > 0L && nbPackages > 0) {
            this.out.print(" (on average " + (double)nbInboundPackages / (double)nbPackages + " per package)");
        }
        this.out.println();
        long nbInboundClasses = metrics.getNbInboundClasses();
        this.out.print("    " + nbInboundClasses + " to class(es)");
        if (nbInboundClasses > 0L && nbClasses > 0) {
            this.out.print(" (on average " + (double)nbInboundClasses / (double)nbClasses + " per class)");
        }
        this.out.println();
        long nbInboundFeatures = metrics.getNbInboundFeatures();
        this.out.print("    " + nbInboundFeatures + " to feature(s)");
        if (nbInboundFeatures > 0L && nbFeatures > 0) {
            this.out.print(" (on average " + (double)nbInboundFeatures / (double)nbFeatures + " per feature)");
        }
        this.out.println();
        if (this.isChartingClassesPerPackage() || this.isChartingFeaturesPerClass() || this.isChartingInboundsPerPackage() || this.isChartingOutboundsPerPackage() || this.isChartingInboundsPerClass() || this.isChartingOutboundsPerClass() || this.isChartingInboundsPerFeature() || this.isChartingOutboundsPerFeature()) {
            this.out.println();
            this.out.print("n");
            if (this.isChartingClassesPerPackage()) {
                this.out.print(", \"classes per package\"");
            }
            if (this.isChartingFeaturesPerClass()) {
                this.out.print(", \"features per class\"");
            }
            if (this.isChartingInboundsPerPackage()) {
                this.out.print(", \"inbounds per package\"");
            }
            if (this.isChartingOutboundsPerPackage()) {
                this.out.print(", \"outbounds per package\"");
            }
            if (this.isChartingInboundsPerClass()) {
                this.out.print(", \"inbounds per class\"");
            }
            if (this.isChartingOutboundsPerClass()) {
                this.out.print(", \"outbounds per class\"");
            }
            if (this.isChartingInboundsPerFeature()) {
                this.out.print(", \"inbounds per feature\"");
            }
            if (this.isChartingOutboundsPerFeature()) {
                this.out.print(", \"outbounds per feature\"");
            }
            this.out.println();
            for (int k = 0; k <= metrics.getChartMaximum(); ++k) {
                long[] dataPoint = metrics.getChartData(k);
                this.out.print(k);
                if (this.isChartingClassesPerPackage()) {
                    this.out.print(", " + dataPoint[1]);
                }
                if (this.isChartingFeaturesPerClass()) {
                    this.out.print(", " + dataPoint[2]);
                }
                if (this.isChartingInboundsPerPackage()) {
                    this.out.print(", " + dataPoint[3]);
                }
                if (this.isChartingOutboundsPerPackage()) {
                    this.out.print(", " + dataPoint[4]);
                }
                if (this.isChartingInboundsPerClass()) {
                    this.out.print(", " + dataPoint[5]);
                }
                if (this.isChartingOutboundsPerClass()) {
                    this.out.print(", " + dataPoint[6]);
                }
                if (this.isChartingInboundsPerFeature()) {
                    this.out.print(", " + dataPoint[7]);
                }
                if (this.isChartingOutboundsPerFeature()) {
                    this.out.print(", " + dataPoint[8]);
                }
                this.out.println();
            }
        }
    }

    private int countConfirmedNodes(Collection<? extends Node> nodes) {
        int result = 0;
        for (Node node : nodes) {
            if (!node.isConfirmed()) continue;
            ++result;
        }
        return result;
    }
}

