/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.commandline;

import com.jeantessier.commandline.AliasSwitch;
import com.jeantessier.commandline.AtLeastParameterStrategy;
import com.jeantessier.commandline.AtMostParameterStrategy;
import com.jeantessier.commandline.CollectingParameterStrategy;
import com.jeantessier.commandline.CommandLine;
import com.jeantessier.commandline.CommandLineSwitch;
import com.jeantessier.commandline.ExactlyParameterStrategy;
import com.jeantessier.commandline.MultipleValuesSwitch;
import com.jeantessier.commandline.NullParameterStrategy;
import com.jeantessier.commandline.OptionalValueSwitch;
import com.jeantessier.commandline.Printer;
import com.jeantessier.commandline.SingleValueSwitch;
import com.jeantessier.commandline.ToggleSwitch;
import com.jeantessier.text.PrinterBuffer;
import java.util.Set;

public class CommandLineUsage
extends Printer {
    private String commandName;
    private PrinterBuffer extraText = new PrinterBuffer();

    public CommandLineUsage(String commandName) {
        this.commandName = commandName;
        this.raiseIndent();
    }

    @Override
    public String toString() {
        PrinterBuffer buffer = new PrinterBuffer();
        buffer.indent().append("USAGE:").eol();
        buffer.raiseIndent();
        buffer.indent().append(this.commandName).eol();
        buffer.lowerIndent();
        buffer.append(super.toString());
        if (this.extraText.length() > 0) {
            buffer.append(this.extraText);
        }
        return buffer.toString();
    }

    @Override
    protected Set<String> getSwitchNames(CommandLine commandLine) {
        return commandLine.getKnownSwitches();
    }

    @Override
    public void visitToggleSwitch(ToggleSwitch cls) {
        if (cls.isMandatory()) {
            this.indent().append("-").append(cls.getName()).append(" (defaults to ").append(cls.getDefaultValue()).append(")").eol();
        } else {
            this.indent().append("[-").append(cls.getName()).append("] (defaults to ").append(cls.getDefaultValue()).append(")").eol();
        }
    }

    @Override
    public void visitSingleValueSwitch(SingleValueSwitch cls) {
        if (cls.isMandatory()) {
            this.indent().append("-").append(cls.getName()).append(" value (defaults to ").append(cls.getDefaultValue()).append(")").eol();
        } else {
            this.indent().append("[-").append(cls.getName()).append(" value] (defaults to ").append(cls.getDefaultValue()).append(")").eol();
        }
    }

    @Override
    public void visitOptionalValueSwitch(OptionalValueSwitch cls) {
        if (cls.isMandatory()) {
            this.indent().append("-").append(cls.getName()).append(" [value] (defaults to ").append(cls.getDefaultValue()).append(")").eol();
        } else {
            this.indent().append("[-").append(cls.getName()).append(" [value]] (defaults to ").append(cls.getDefaultValue()).append(")").eol();
        }
    }

    @Override
    public void visitMultipleValuesSwitch(MultipleValuesSwitch cls) {
        if (cls.isMandatory()) {
            this.indent().append("(-").append(cls.getName()).append(" value)+ (defaults to ").append(cls.getDefaultValue()).append(")").eol();
        } else {
            this.indent().append("(-").append(cls.getName()).append(" value)* (defaults to ").append(cls.getDefaultValue()).append(")").eol();
        }
    }

    @Override
    public void visitAliasSwitch(AliasSwitch cls) {
        this.indent().append("[-").append(cls.getName()).append("]").eol();
        this.extraText.eol();
        this.extraText.indent().append("-").append(cls.getName()).append(" is shorthand for the combination:").eol();
        this.extraText.raiseIndent();
        for (CommandLineSwitch commandLineSwitch : cls.getSwitches()) {
            this.extraText.indent().append("-").append(commandLineSwitch.getName()).eol();
        }
        this.extraText.lowerIndent();
    }

    @Override
    public void visitNullParameterStrategy(NullParameterStrategy strategy) {
    }

    @Override
    public void visitCollectingParameterStrategy(CollectingParameterStrategy strategy) {
        this.indent().append("[param ...]").eol();
    }

    @Override
    public void visitAtLeastParameterStrategy(AtLeastParameterStrategy strategy) {
        for (int i = 1; i <= strategy.getLimit(); ++i) {
            this.indent().append("param").append(i).eol();
        }
        this.indent().append("...").eol();
    }

    @Override
    public void visitExactlyParameterStrategy(ExactlyParameterStrategy strategy) {
        for (int i = 1; i <= strategy.getLimit(); ++i) {
            this.indent().append("param").append(i).eol();
        }
    }

    @Override
    public void visitAtMostParameterStrategy(AtMostParameterStrategy strategy) {
        int i;
        this.indent();
        for (i = 1; i <= strategy.getLimit(); ++i) {
            this.append("[param").append(i);
            if (i >= strategy.getLimit()) continue;
            this.append(" ");
        }
        for (i = 1; i <= strategy.getLimit(); ++i) {
            this.append("]");
        }
        this.eol();
    }
}

