/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.LineNumber;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class LineNumberTable_attribute
extends Attribute_info
implements com.jeantessier.classreader.LineNumberTable_attribute {
    private Collection<LineNumber> lineNumbers = new LinkedList<LineNumber>();

    public LineNumberTable_attribute(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        super(constantPool, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int lineNumberTableLength = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + lineNumberTableLength + " line number(s) ..."));
        for (int i = 0; i < lineNumberTableLength; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Line number entry " + i + ":"));
            this.lineNumbers.add(new LineNumber(this, in));
        }
    }

    public Collection<LineNumber> getLineNumbers() {
        return this.lineNumbers;
    }

    public String toString() {
        return "Line Number Table";
    }

    @Override
    public String getAttributeName() {
        return AttributeType.LINE_NUMBER_TABLE.getAttributeName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLineNumberTable_attribute(this);
    }
}

