/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.DescriptorHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;

class DescriptorIterator
implements Iterator {
    private String descriptor;
    private int currentPos = 0;

    public DescriptorIterator(String descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.descriptor.length();
    }

    public Object next() {
        int nextPos;
        if (this.hasNext()) {
            nextPos = this.currentPos;
            while (this.descriptor.charAt(nextPos) == '[') {
                ++nextPos;
            }
            if (this.descriptor.charAt(nextPos) == 'L') {
                nextPos = this.descriptor.indexOf(";", nextPos);
            }
        } else {
            throw new NoSuchElementException();
        }
        String result = DescriptorHelper.convert(this.descriptor.substring(this.currentPos, nextPos + 1));
        this.currentPos = nextPos + 1;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

