/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyImageManager;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.RenderStates;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.ObjectPool;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;

public class NiftyRenderEngineImpl
implements NiftyRenderEngine {
    private Logger log = Logger.getLogger(NiftyRenderEngineImpl.class.getName());
    private RenderDevice renderDevice;
    private int displayWidth;
    private int displayHeight;
    private float globalPosX = 0.0f;
    private float globalPosY = 0.0f;
    private float currentX = 0.0f;
    private float currentY = 0.0f;
    private RenderFont font;
    private Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private boolean colorChanged = false;
    private boolean colorAlphaChanged = false;
    private float imageScale = 1.0f;
    private float textScale = 1.0f;
    private Map<String, RenderFont> fontCache = new Hashtable<String, RenderFont>();
    private Stack<SavedRenderState> stack = new Stack();
    private Color whiteColor = new Color("#ffff");
    private ObjectPool<SavedRenderState> pool = new ObjectPool<SavedRenderState>(32, new ObjectPool.Factory<SavedRenderState>(){

        @Override
        public SavedRenderState createNew() {
            return new SavedRenderState();
        }
    });
    private boolean clipEnabled;
    private Clip clip = new Clip(0, 0, 0, 0);
    private BlendMode blendMode = BlendMode.BLEND;
    private NiftyImageManager imageManager;

    public NiftyRenderEngineImpl(RenderDevice renderDeviceParam) {
        this.renderDevice = renderDeviceParam;
        this.displayWidth = this.renderDevice.getWidth();
        this.displayHeight = this.renderDevice.getHeight();
        this.imageManager = new NiftyImageManager(renderDeviceParam);
    }

    @Override
    public int getWidth() {
        return this.displayWidth;
    }

    @Override
    public int getHeight() {
        return this.displayHeight;
    }

    @Override
    public void beginFrame() {
        this.renderDevice.beginFrame();
        this.colorChanged = false;
    }

    @Override
    public void endFrame() {
        this.renderDevice.endFrame();
    }

    @Override
    public void clear() {
        this.renderDevice.clear();
    }

    @Override
    public NiftyImage createImage(String filename, boolean filterLinear) {
        if (filename == null) {
            return null;
        }
        return new NiftyImage(this, this.imageManager.getImage(filename, filterLinear));
    }

    @Override
    public RenderFont createFont(String filename) {
        if (filename == null) {
            return null;
        }
        if (this.fontCache.containsKey(filename)) {
            return this.fontCache.get(filename);
        }
        NiftyStopwatch.start();
        RenderFont newFont = this.renderDevice.createFont(filename);
        this.fontCache.put(filename, newFont);
        NiftyStopwatch.stop("RenderDevice.createFont(" + filename + ")");
        return newFont;
    }

    @Override
    public String getFontname(RenderFont font) {
        for (Map.Entry<String, RenderFont> entry : this.fontCache.entrySet()) {
            if (!entry.getValue().equals(font)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void renderQuad(int x, int y, int width, int height) {
        this.renderDevice.renderQuad(x + this.getX(), y + this.getY(), width, height, this.color);
    }

    @Override
    public void renderQuad(int x, int y, int width, int height, Color topLeft, Color topRight, Color bottomRight, Color bottomLeft) {
        if (this.isColorAlphaChanged()) {
            Color a = new Color(topLeft, this.color.getAlpha());
            Color b = new Color(topRight, this.color.getAlpha());
            Color c = new Color(bottomRight, this.color.getAlpha());
            Color d = new Color(bottomLeft, this.color.getAlpha());
            this.renderDevice.renderQuad(x + this.getX(), y + this.getY(), width, height, a, b, c, d);
        } else {
            this.renderDevice.renderQuad(x + this.getX(), y + this.getY(), width, height, topLeft, topRight, bottomRight, bottomLeft);
        }
    }

    @Override
    public void renderImage(NiftyImage image, int x, int y, int width, int height) {
        float alpha = 1.0f;
        if (this.color != null) {
            alpha = this.color.getAlpha();
        }
        this.whiteColor.setAlpha(alpha);
        image.render(x + this.getX(), y + this.getY(), width, height, this.whiteColor, this.imageScale);
    }

    @Override
    public void renderText(String text, int x, int y, int selectionStart, int selectionEnd, Color textSelectionColor) {
        if (this.isSelection(selectionStart, selectionEnd)) {
            this.renderSelectionText(text, x + this.getX(), y + this.getY(), this.color, textSelectionColor, this.textScale, selectionStart, selectionEnd);
        } else {
            if (this.font == null || this.font instanceof TextRenderer.RenderFontNull) {
                this.log.warning("missing font in renderText! could it be that you're using <text> elements without a font or style attribute? in case you've replaced <label> with <text> you're probably missing style='nifty-label' :)");
                return;
            }
            this.renderDevice.renderFont(this.font, text, x + this.getX(), y + this.getY(), this.color, this.textScale);
        }
    }

    protected void renderSelectionText(String text, int x, int y, Color textColor, Color textSelectionColor, float textSize, int selectionStartParam, int selectionEndParam) {
        int selectionStart = selectionStartParam;
        int selectionEnd = selectionEndParam;
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionEnd < 0) {
            selectionEnd = 0;
        }
        if (this.isEverythingSelected(text, selectionStart, selectionEnd)) {
            this.renderDevice.renderFont(this.font, text, x, y, textSelectionColor, textSize);
        } else if (this.isSelectionAtBeginning(selectionStart)) {
            String selectedString = text.substring(selectionStart, selectionEnd);
            String unselectedString = text.substring(selectionEnd);
            this.renderDevice.renderFont(this.font, selectedString, x, y, textSelectionColor, textSize);
            this.renderDevice.renderFont(this.font, unselectedString, x + this.font.getWidth(selectedString), y, textColor, textSize);
        } else if (this.isSelectionAtEnd(text, selectionEnd)) {
            String unselectedString = text.substring(0, selectionStart);
            String selectedString = text.substring(selectionStart, selectionEnd);
            this.renderDevice.renderFont(this.font, unselectedString, x, y, textColor, textSize);
            this.renderDevice.renderFont(this.font, selectedString, x + this.font.getWidth(unselectedString), y, textSelectionColor, textSize);
        } else {
            String unselectedString1 = text.substring(0, selectionStart);
            String selectedString = text.substring(selectionStart, selectionEnd);
            String unselectedString2 = text.substring(selectionEnd, text.length());
            this.renderDevice.renderFont(this.font, unselectedString1, x, y, textColor, textSize);
            int unselectedString1Len = this.font.getWidth(unselectedString1);
            this.renderDevice.renderFont(this.font, selectedString, x + unselectedString1Len, y, textSelectionColor, textSize);
            int selectedStringLen = this.font.getWidth(selectedString);
            this.renderDevice.renderFont(this.font, unselectedString2, x + unselectedString1Len + selectedStringLen, y, textColor, textSize);
        }
    }

    private boolean isSelectionAtEnd(String text, int selectionEnd) {
        return selectionEnd == text.length();
    }

    private boolean isSelectionAtBeginning(int selectionStart) {
        return selectionStart == 0;
    }

    private boolean isEverythingSelected(String text, int selectionStart, int selectionEnd) {
        return this.isSelectionAtBeginning(selectionStart) && this.isSelectionAtEnd(text, selectionEnd);
    }

    @Override
    public void setFont(RenderFont newFont) {
        this.font = newFont;
    }

    @Override
    public RenderFont getFont() {
        return this.font;
    }

    @Override
    public void setColor(Color colorParam) {
        this.color.setRed(colorParam.getRed());
        this.color.setGreen(colorParam.getGreen());
        this.color.setBlue(colorParam.getBlue());
        this.color.setAlpha(colorParam.getAlpha());
        this.colorChanged = true;
        this.colorAlphaChanged = true;
    }

    @Override
    public void setColorAlpha(float newColorAlpha) {
        this.color.setAlpha(newColorAlpha);
        this.colorAlphaChanged = true;
    }

    @Override
    public void setColorIgnoreAlpha(Color newColor) {
        this.color.setRed(newColor.getRed());
        this.color.setGreen(newColor.getGreen());
        this.color.setBlue(newColor.getBlue());
        this.colorChanged = true;
        if (this.colorAlphaChanged && this.color.getAlpha() > newColor.getAlpha()) {
            this.color.setAlpha(newColor.getAlpha());
            this.colorAlphaChanged = true;
        }
    }

    @Override
    public boolean isColorChanged() {
        return this.colorChanged;
    }

    @Override
    public boolean isColorAlphaChanged() {
        return this.colorAlphaChanged;
    }

    @Override
    public void moveTo(float xParam, float yParam) {
        this.currentX = xParam;
        this.currentY = yParam;
    }

    @Override
    public void enableClip(int x0, int y0, int x1, int y1) {
        if (this.clipEnabled) {
            return;
        }
        this.updateClip(true, x0 + this.getX(), y0 + this.getY(), x1 + this.getX(), y1 + this.getY());
    }

    @Override
    public void disableClip() {
        this.updateClip(false, 0, 0, 0, 0);
    }

    void updateClip(boolean enabled, int x0, int y0, int x1, int y1) {
        this.clipEnabled = enabled;
        this.clip.init(x0, y0, x1, y1);
        if (!this.clipEnabled) {
            this.renderDevice.disableClip();
        } else {
            this.clip.apply();
        }
    }

    @Override
    public void setRenderTextSize(float size) {
        this.textScale = size;
    }

    @Override
    public void setImageScale(float scale) {
        this.imageScale = scale;
    }

    @Override
    public void setGlobalPosition(float xPos, float yPos) {
        this.globalPosX = xPos;
        this.globalPosY = yPos;
    }

    @Override
    public void displayResolutionChanged() {
        this.displayWidth = this.renderDevice.getWidth();
        this.displayHeight = this.renderDevice.getHeight();
    }

    private int getX() {
        return (int)(this.globalPosX + this.currentX);
    }

    private int getY() {
        return (int)(this.globalPosY + this.currentY);
    }

    private boolean isSelection(int selectionStart, int selectionEnd) {
        return selectionStart != -1 || selectionEnd != -1;
    }

    @Override
    public void saveState(RenderStates statesToSave) {
        SavedRenderState savedRenderState = this.pool.allocate();
        savedRenderState.save(statesToSave);
        this.stack.push(savedRenderState);
    }

    @Override
    public void restoreState() {
        SavedRenderState restored = this.stack.pop();
        restored.restore();
        this.pool.free(restored);
    }

    @Override
    public void setBlendMode(BlendMode blendModeParam) {
        this.blendMode = blendModeParam;
        this.renderDevice.setBlendMode(blendModeParam);
    }

    @Override
    public RenderDevice getRenderDevice() {
        return this.renderDevice;
    }

    @Override
    public void disposeImage(RenderImage image) {
        this.imageManager.dispose(image);
    }

    @Override
    public RenderImage reload(RenderImage image) {
        return this.imageManager.reload(image);
    }

    public class Clip {
        private int x0;
        private int y0;
        private int x1;
        private int y1;

        public Clip(int x0, int y0, int x1, int y1) {
            this.init(x0, y0, x1, y1);
        }

        public void init(int x0, int y0, int x1, int y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        public void apply() {
            NiftyRenderEngineImpl.this.renderDevice.enableClip(this.x0, this.y0, this.x1, this.y1);
        }
    }

    private class SavedRenderState {
        private float x;
        private float y;
        private boolean statePositionChanged;
        private float colorR;
        private float colorG;
        private float colorB;
        private boolean colorChanged;
        private boolean stateColorChanged;
        private float colorAlpha;
        private boolean colorAlphaChanged;
        private boolean stateAlphaChanged;
        private RenderFont font;
        private boolean stateFontChanged;
        private float textSize;
        private boolean stateTextSizeChanged;
        private float imageScale;
        private boolean stateImageScaleChanged;
        private boolean clipEnabled;
        private Clip clip;
        private boolean stateClipChanged;
        private BlendMode blendMode;
        private boolean stateBlendModeChanged;
        private boolean restoreAll;

        public SavedRenderState() {
            this.clip = new Clip(0, 0, 0, 0);
            this.restoreAll = false;
        }

        public void save(RenderStates statesToSave) {
            this.statePositionChanged = false;
            this.stateColorChanged = false;
            this.stateAlphaChanged = false;
            this.stateFontChanged = false;
            this.stateTextSizeChanged = false;
            this.stateImageScaleChanged = false;
            this.stateClipChanged = false;
            this.stateBlendModeChanged = false;
            this.restoreAll = false;
            if (statesToSave == null) {
                this.savePosition();
                this.saveColor();
                this.saveColorAlpha();
                this.saveTextSize();
                this.saveImageSize();
                this.saveFont();
                this.saveClipEnabled();
                this.saveBlendMode();
                this.restoreAll = true;
                return;
            }
            if (statesToSave.hasPosition()) {
                this.savePosition();
            } else if (statesToSave.hasColor()) {
                this.saveColor();
            } else if (statesToSave.hasAlpha()) {
                this.saveColorAlpha();
            } else if (statesToSave.hasTextSize()) {
                this.saveTextSize();
            } else if (statesToSave.hasImageScale()) {
                this.saveImageSize();
            } else if (statesToSave.hasFont()) {
                this.saveFont();
            } else if (statesToSave.hasClip()) {
                this.saveClipEnabled();
            } else if (statesToSave.hasBlendMode()) {
                this.saveBlendMode();
            }
        }

        public void restore() {
            if (this.restoreAll) {
                this.restorePosition();
                this.restoreColor();
                this.restoreAlpha();
                this.restoreFont();
                this.restoreTextSize();
                this.restoreImageScale();
                this.restoreClip();
                this.restoreBlend();
                return;
            }
            if (this.statePositionChanged) {
                this.restorePosition();
            }
            if (this.stateColorChanged) {
                this.restoreColor();
            }
            if (this.stateAlphaChanged) {
                this.restoreAlpha();
            }
            if (this.stateFontChanged) {
                this.restoreFont();
            }
            if (this.stateTextSizeChanged) {
                this.restoreTextSize();
            }
            if (this.stateImageScaleChanged) {
                this.restoreImageScale();
            }
            if (this.stateClipChanged) {
                this.restoreClip();
            }
            if (this.stateBlendModeChanged) {
                this.restoreBlend();
            }
        }

        private void saveBlendMode() {
            this.blendMode = NiftyRenderEngineImpl.this.blendMode;
            this.stateBlendModeChanged = true;
        }

        private void saveClipEnabled() {
            this.clipEnabled = NiftyRenderEngineImpl.this.clipEnabled;
            this.clip.init(NiftyRenderEngineImpl.this.clip.x0, NiftyRenderEngineImpl.this.clip.y0, NiftyRenderEngineImpl.this.clip.x1, NiftyRenderEngineImpl.this.clip.y1);
            this.stateClipChanged = true;
        }

        private void saveFont() {
            this.font = NiftyRenderEngineImpl.this.font;
            this.stateFontChanged = true;
        }

        private void saveImageSize() {
            this.imageScale = NiftyRenderEngineImpl.this.imageScale;
            this.stateImageScaleChanged = true;
        }

        private void saveTextSize() {
            this.textSize = NiftyRenderEngineImpl.this.textScale;
            this.stateTextSizeChanged = true;
        }

        private void saveColorAlpha() {
            this.colorAlpha = NiftyRenderEngineImpl.this.color.getAlpha();
            this.colorAlphaChanged = NiftyRenderEngineImpl.this.colorAlphaChanged;
            this.stateAlphaChanged = true;
        }

        private void saveColor() {
            this.colorR = NiftyRenderEngineImpl.this.color.getRed();
            this.colorG = NiftyRenderEngineImpl.this.color.getGreen();
            this.colorB = NiftyRenderEngineImpl.this.color.getBlue();
            this.colorChanged = NiftyRenderEngineImpl.this.colorChanged;
            this.stateColorChanged = true;
        }

        private void savePosition() {
            this.x = NiftyRenderEngineImpl.this.currentX;
            this.y = NiftyRenderEngineImpl.this.currentY;
            this.statePositionChanged = true;
        }

        private void restoreBlend() {
            NiftyRenderEngineImpl.this.setBlendMode(this.blendMode);
        }

        private void restoreClip() {
            NiftyRenderEngineImpl.this.updateClip(this.clipEnabled, this.clip.x0, this.clip.y0, this.clip.x1, this.clip.y1);
        }

        private void restoreImageScale() {
            NiftyRenderEngineImpl.this.imageScale = this.imageScale;
        }

        private void restoreTextSize() {
            NiftyRenderEngineImpl.this.textScale = this.textSize;
        }

        private void restoreFont() {
            NiftyRenderEngineImpl.this.font = this.font;
        }

        private void restoreAlpha() {
            NiftyRenderEngineImpl.this.color.setAlpha(this.colorAlpha);
            NiftyRenderEngineImpl.this.colorAlphaChanged = this.colorAlphaChanged;
        }

        private void restoreColor() {
            NiftyRenderEngineImpl.this.color.setRed(this.colorR);
            NiftyRenderEngineImpl.this.color.setGreen(this.colorG);
            NiftyRenderEngineImpl.this.color.setBlue(this.colorB);
            NiftyRenderEngineImpl.this.colorChanged = this.colorChanged;
        }

        private void restorePosition() {
            NiftyRenderEngineImpl.this.currentX = this.x;
            NiftyRenderEngineImpl.this.currentY = this.y;
        }
    }
}

