/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollbar;

import de.lessvoid.nifty.controls.scrollbar.ScrollbarView;

public class ScrollbarImpl {
    private ScrollbarView view;
    private float value;
    private float oldValue;
    private float min = 0.0f;
    private float worldMax;
    private float worldPageSize;
    private float buttonStepSize;
    private float pageStepSize;
    private boolean moveTheHandle;
    private int moveTheHandleStartPosDelta;

    public void bindToView(ScrollbarView view, float value, float worldMax, float worldPageSize, float buttonStepSize, float pageStepSize) {
        this.view = view;
        this.value = value;
        this.oldValue = -1.0f;
        this.worldMax = worldMax;
        this.worldPageSize = worldPageSize;
        this.buttonStepSize = buttonStepSize;
        this.pageStepSize = pageStepSize;
        this.moveTheHandle = false;
        this.ensureWorldPageSize();
        this.updateView();
        this.changeValue(this.value);
    }

    public void setup(float value, float worldMax, float worldPageSize, float buttonStepSize, float pageStepSize) {
        this.value = value;
        this.worldMax = worldMax;
        this.worldPageSize = worldPageSize;
        this.buttonStepSize = buttonStepSize;
        this.pageStepSize = pageStepSize;
        this.ensureWorldPageSize();
        this.changeValue(value);
        this.updateView();
    }

    public void setValue(float value) {
        this.changeValue(value);
        this.updateView();
    }

    public float getValue() {
        return this.value;
    }

    public void stepUp() {
        this.changeValue(this.value + this.buttonStepSize);
        this.updateView();
    }

    public void stepDown() {
        this.changeValue(this.value - this.buttonStepSize);
        this.updateView();
    }

    public void stepPageUp() {
        this.changeValue(this.value + this.pageStepSize);
        this.updateView();
    }

    public void stepPageDown() {
        this.changeValue(this.value - this.pageStepSize);
        this.updateView();
    }

    public float getWorldMax() {
        return this.worldMax;
    }

    public void setWorldMax(float max) {
        this.worldMax = max;
        this.ensureWorldPageSize();
        this.changeValue(this.value);
        this.updateView();
    }

    public float getWorldPageSize() {
        return this.worldPageSize;
    }

    public void setWorldPageSize(float worldPageSize) {
        this.worldPageSize = worldPageSize;
        this.ensureWorldPageSize();
        this.changeValue(this.value);
        this.updateView();
    }

    public float getButtonStepSize() {
        return this.buttonStepSize;
    }

    public void setButtonStepSize(float buttonStepSize) {
        this.buttonStepSize = buttonStepSize;
        this.changeValue(this.value);
        this.updateView();
    }

    public float getPageStepSize() {
        return this.pageStepSize;
    }

    public void setPageStepSize(float pageStepSize) {
        this.pageStepSize = pageStepSize;
    }

    public void interactionClick(int viewValueClicked) {
        int handleSize;
        int viewSize = this.view.getAreaSize();
        int handlePosition = this.calcHandlePosition(viewSize, handleSize = this.calcHandleSize(viewSize));
        if (this.hitsHandle(handlePosition, handleSize, viewValueClicked)) {
            this.moveTheHandle = true;
            this.moveTheHandleStartPosDelta = viewValueClicked - handlePosition;
        } else {
            this.moveTheHandle = false;
            if (viewValueClicked < handlePosition && viewValueClicked > 0) {
                this.stepPageDown();
            } else if (viewValueClicked > handlePosition + handleSize && viewValueClicked < viewSize) {
                this.stepPageUp();
            }
        }
    }

    public void interactionMove(int viewValue) {
        if (!this.moveTheHandle) {
            return;
        }
        int viewSize = this.view.getAreaSize();
        if (viewValue < 0 || viewValue >= viewSize) {
            return;
        }
        int newViewPos = viewValue - this.moveTheHandleStartPosDelta;
        int handleSize = this.calcHandleSize(viewSize);
        float newWorldValue = this.viewToWorld(newViewPos, viewSize - handleSize, this.worldMax - this.worldPageSize);
        this.changeValue(newWorldValue);
        this.updateView();
    }

    private boolean hitsHandle(int handlePosition, int handleSize, int viewValueClicked) {
        return viewValueClicked > handlePosition && viewValueClicked < handlePosition + handleSize;
    }

    private void changeValue(float newValue) {
        this.value = newValue;
        if (this.value > this.worldMax - this.worldPageSize) {
            this.value = this.worldMax - this.worldPageSize;
        } else if (newValue < this.min) {
            this.value = this.min;
        }
        if (this.value != this.oldValue) {
            this.oldValue = this.value;
            this.view.valueChanged(this.value);
        }
    }

    public void updateView() {
        int viewSize = this.view.getAreaSize();
        int handleSize = this.calcHandleSize(viewSize);
        this.view.setHandle(this.calcHandlePosition(viewSize, handleSize), handleSize);
    }

    private int calcHandlePosition(int viewSize, int handleSize) {
        int viewMin = (int)Math.floor(this.worldToView(this.value, this.worldMax - this.worldPageSize, viewSize - handleSize));
        if (viewMin + handleSize > viewSize) {
            viewMin = viewSize - handleSize;
        }
        return viewMin;
    }

    private int calcHandleSize(int viewSize) {
        int minHandleSize = this.view.getMinHandleSize();
        if (this.worldMax == 0.0f) {
            return viewSize;
        }
        int handleSize = (int)Math.floor(this.worldPageSize * (float)viewSize / this.worldMax);
        if (handleSize < minHandleSize) {
            return minHandleSize;
        }
        if (handleSize > viewSize) {
            return viewSize;
        }
        return handleSize;
    }

    private float viewToWorld(float viewValue, float viewMaxValue, float worldMaxValue) {
        return viewValue / viewMaxValue * worldMaxValue;
    }

    private float worldToView(float worldValue, float worldMaxValue, float viewMaxValue) {
        if (this.worldMax == 0.0f) {
            return 0.0f;
        }
        return Math.round(worldValue / worldMaxValue * viewMaxValue);
    }

    private void ensureWorldPageSize() {
        if (this.worldPageSize > this.worldMax) {
            this.worldPageSize = this.worldMax;
        }
    }
}

