/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.console;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Properties;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class ConsoleControl
extends AbstractController
implements Console,
EventTopicSubscriber<NiftyInputEvent> {
    private Nifty nifty;
    private Screen screen;
    private Element element;
    private ListBox<String> listBox;
    private TextField textfield;
    private Color standardColor = null;
    private Color errorColor = new Color("#f00a");

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, Attributes controlDefinitionAttributes) {
        super.bind(newElement);
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.element = newElement;
        this.listBox = (ListBox)this.element.findNiftyControl("#listBox", ListBox.class);
        this.textfield = (TextField)this.element.findNiftyControl("#textInput", TextField.class);
        this.initialFill();
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        this.nifty.subscribe(this.screen, this.textfield.getId(), NiftyInputEvent.class, (EventTopicSubscriber)this);
        super.init(parameter, controlDefinitionAttributes);
    }

    public void onStartScreen() {
        this.element.findElementByName("#textInput").setFocus();
    }

    @Override
    public TextField getTextField() {
        return this.textfield;
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEvent(String topic, NiftyInputEvent data) {
        if (data.equals((Object)NiftyInputEvent.SubmitText)) {
            String text = this.textfield.getText();
            this.listBox.addItem(text);
            this.listBox.showItemByIndex(this.listBox.itemCount() - 1);
            this.textfield.setText("");
            this.nifty.publishEvent(this.element.getId(), (NiftyEvent)new ConsoleExecuteCommandEvent(this, text));
        }
    }

    @Override
    public void output(String value) {
        this.out(value, this.standardColor);
    }

    @Override
    public void output(String value, Color color) {
        this.out(value, color);
    }

    @Override
    public void outputError(String value) {
        this.out(value, this.errorColor);
    }

    @Override
    public String[] getConsoleContent() {
        return this.listBox.getItems().toArray(new String[0]);
    }

    @Override
    public void clear() {
        this.listBox.clear();
        this.initialFill();
    }

    @Override
    public void changeColors(Color standardColor, Color errorColor) {
        this.standardColor = standardColor;
        this.errorColor = errorColor;
    }

    private void initialFill() {
        for (int i = 0; i < this.listBox.getDisplayItemCount(); ++i) {
            this.listBox.addItem("");
        }
    }

    private void out(String param, Color color) {
        String value = this.nifty.specialValuesReplace(param);
        String[] lines = value.split("\n");
        ArrayList<String> list = new ArrayList<String>(lines.length);
        for (String line : lines) {
            if (color != null) {
                list.add("\\" + color.getColorString() + "#" + line);
                continue;
            }
            list.add(line);
        }
        this.listBox.addAllItems(list);
        this.listBox.showItemByIndex(this.listBox.itemCount() - 1);
    }
}

