/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.util.ReflectionUtil;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLGLCapabilities;

public class EGLGraphicsConfiguration
extends DefaultGraphicsConfiguration
implements Cloneable {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");
    private GLCapabilitiesChooser chooser;

    public final long getNativeConfig() {
        return ((EGLGLCapabilities)this.capabilitiesChosen).getEGLConfig();
    }

    public final int getNativeConfigID() {
        return ((EGLGLCapabilities)this.capabilitiesChosen).getEGLConfigID();
    }

    EGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, EGLGLCapabilities eGLGLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, (CapabilitiesImmutable)eGLGLCapabilities, (CapabilitiesImmutable)gLCapabilitiesImmutable);
        this.chooser = gLCapabilitiesChooser;
    }

    public static EGLGraphicsConfiguration create(GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        long l2 = EGLGraphicsConfiguration.EGLConfigId2EGLConfig(gLProfile, l, n);
        EGLGLCapabilities eGLGLCapabilities = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLProfile, l, l2, false, gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isPBuffer());
        return new EGLGraphicsConfiguration(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable, new DefaultGLCapabilitiesChooser());
    }

    public Object clone() {
        return super.clone();
    }

    void updateGraphicsConfiguration() {
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)this.getScreen().getDevice()).chooseGraphicsConfiguration(this.getChosenCapabilities(), this.getRequestedCapabilities(), (CapabilitiesChooser)this.chooser, this.getScreen());
        if (null != eGLGraphicsConfiguration) {
            this.setChosenCapabilities(eGLGraphicsConfiguration.getChosenCapabilities());
            if (DEBUG) {
                System.err.println("!!! updateGraphicsConfiguration: " + this);
            }
        }
    }

    public static long EGLConfigId2EGLConfig(GLProfile gLProfile, long l, int n) {
        int[] nArray;
        int[] nArray2 = new int[]{12328, n, 12344};
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
        if (!EGL.eglChooseConfig(l, nArray2, 0, pointerBuffer, 1, nArray = new int[1], 0)) {
            return 0L;
        }
        if (nArray[0] == 0) {
            return 0L;
        }
        return pointerBuffer.get(0);
    }

    static int EGLConfigDrawableTypeBits(long l, long l2) {
        int n = 0;
        int[] nArray = new int[1];
        if (!EGL.eglGetConfigAttrib(l, l2, 12339, nArray, 0)) {
            throw new GLException("Could not determine EGL_SURFACE_TYPE !!!");
        }
        if (0 != (nArray[0] & 4)) {
            n |= 1;
        }
        if (0 != (nArray[0] & 2)) {
            n |= 2;
        }
        if (0 != (nArray[0] & 1)) {
            n |= 4;
        }
        return n;
    }

    public static EGLGLCapabilities EGLConfig2Capabilities(GLProfile gLProfile, long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        int n = GLGraphicsConfigurationUtil.getWinAttributeBits(bl2, bl3);
        if (EGLGraphicsConfiguration.EGLConfig2Capabilities(arrayList, gLProfile, l, l2, n)) {
            return (EGLGLCapabilities)arrayList.get(0);
        }
        if (bl && EGLGraphicsConfiguration.EGLConfig2Capabilities(arrayList, gLProfile, l, l2, 7)) {
            return (EGLGLCapabilities)arrayList.get(0);
        }
        return null;
    }

    public static boolean EGLConfig2Capabilities(ArrayList arrayList, GLProfile gLProfile, long l, long l2, int n) {
        int n2 = EGLGraphicsConfiguration.EGLConfigDrawableTypeBits(l, l2);
        int n3 = n & n2;
        if (0 == n3) {
            return false;
        }
        int[] nArray = new int[1];
        if (!EGL.eglGetConfigAttrib(l, l2, 12328, nArray, 0)) {
            if (DEBUG) {
                System.err.println("EGL couldn't retrieve ConfigID for config " + EGLGraphicsConfiguration.toHexString((long)l2) + ", error " + EGLGraphicsConfiguration.toHexString((int)EGL.eglGetError()));
            }
            return false;
        }
        EGLGLCapabilities eGLGLCapabilities = new EGLGLCapabilities(l2, nArray[0], gLProfile);
        if (EGL.eglGetConfigAttrib(l, l2, 12324, nArray, 0)) {
            eGLGLCapabilities.setRedBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12323, nArray, 0)) {
            eGLGLCapabilities.setGreenBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12322, nArray, 0)) {
            eGLGLCapabilities.setBlueBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12321, nArray, 0)) {
            eGLGLCapabilities.setAlphaBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12326, nArray, 0)) {
            eGLGLCapabilities.setStencilBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12325, nArray, 0)) {
            eGLGLCapabilities.setDepthBits(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12337, nArray, 0)) {
            eGLGLCapabilities.setSampleBuffers(nArray[0] > 0);
            eGLGLCapabilities.setNumSamples(nArray[0]);
        }
        if (EGL.eglGetConfigAttrib(l, l2, 12340, nArray, 0)) {
            eGLGLCapabilities.setBackgroundOpaque(nArray[0] != 12370);
        }
        if (!eGLGLCapabilities.isBackgroundOpaque()) {
            if (EGL.eglGetConfigAttrib(l, l2, 12343, nArray, 0)) {
                eGLGLCapabilities.setTransparentRedValue(nArray[0] == -1 ? -1 : nArray[0]);
            }
            if (EGL.eglGetConfigAttrib(l, l2, 12342, nArray, 0)) {
                eGLGLCapabilities.setTransparentGreenValue(nArray[0] == -1 ? -1 : nArray[0]);
            }
            if (EGL.eglGetConfigAttrib(l, l2, 12341, nArray, 0)) {
                eGLGLCapabilities.setTransparentBlueValue(nArray[0] == -1 ? -1 : nArray[0]);
            }
        }
        return GLGraphicsConfigurationUtil.addGLCapabilitiesPermutations(arrayList, eGLGLCapabilities, n3);
    }

    public static int[] GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        int[] nArray = new int[32];
        int n = 0;
        nArray[n++] = 12339;
        nArray[n++] = gLCapabilitiesImmutable.isOnscreen() ? 4 : (gLCapabilitiesImmutable.isPBuffer() ? 1 : 2);
        nArray[n++] = 12324;
        nArray[n++] = gLCapabilitiesImmutable.getRedBits();
        nArray[n++] = 12323;
        nArray[n++] = gLCapabilitiesImmutable.getGreenBits();
        nArray[n++] = 12322;
        nArray[n++] = gLCapabilitiesImmutable.getBlueBits();
        nArray[n++] = 12321;
        nArray[n++] = gLCapabilitiesImmutable.getAlphaBits() > 0 ? gLCapabilitiesImmutable.getAlphaBits() : -1;
        nArray[n++] = 12326;
        nArray[n++] = gLCapabilitiesImmutable.getStencilBits() > 0 ? gLCapabilitiesImmutable.getStencilBits() : -1;
        nArray[n++] = 12325;
        nArray[n++] = gLCapabilitiesImmutable.getDepthBits();
        nArray[n++] = 12337;
        nArray[n++] = gLCapabilitiesImmutable.getSampleBuffers() ? gLCapabilitiesImmutable.getNumSamples() : 1;
        nArray[n++] = 12340;
        int n2 = nArray[n++] = gLCapabilitiesImmutable.isBackgroundOpaque() ? 12344 : 12340;
        if (!gLCapabilitiesImmutable.isBackgroundOpaque()) {
            nArray[n++] = 12343;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentRedValue() >= 0 ? gLCapabilitiesImmutable.getTransparentRedValue() : -1;
            nArray[n++] = 12342;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentGreenValue() >= 0 ? gLCapabilitiesImmutable.getTransparentGreenValue() : -1;
            nArray[n++] = 12341;
            nArray[n++] = gLCapabilitiesImmutable.getTransparentBlueValue() >= 0 ? gLCapabilitiesImmutable.getTransparentBlueValue() : -1;
        }
        nArray[n++] = 12352;
        nArray[n++] = gLCapabilitiesImmutable.getGLProfile().usesNativeGLES1() ? 1 : (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES2() ? 4 : 8);
        nArray[n++] = 12344;
        return nArray;
    }

    public static int[] CreatePBufferSurfaceAttribList(int n, int n2, int n3) {
        int[] nArray = new int[16];
        int n4 = 0;
        nArray[n4++] = 12375;
        nArray[n4++] = n;
        nArray[n4++] = 12374;
        nArray[n4++] = n2;
        nArray[n4++] = 12416;
        nArray[n4++] = n3;
        nArray[n4++] = 12417;
        nArray[n4++] = 12380 == n3 ? 12380 : 12383;
        nArray[n4++] = 12344;
        return nArray;
    }

    public String toString() {
        return ReflectionUtil.getBaseName(this.getClass()) + "[" + this.getScreen() + ", eglConfigID " + EGLGraphicsConfiguration.toHexString((int)this.getNativeConfigID()) + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

