/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import java.util.HashMap;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import jogamp.nativewindow.ProxySurface;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLES1DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLES2DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLExternalContext;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLOnscreenDrawable;
import jogamp.opengl.egl.EGLPbufferDrawable;

public class EGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final GLDynamicLookupHelper eglES1DynamicLookupHelper;
    private static final GLDynamicLookupHelper eglES2DynamicLookupHelper;
    HashMap sharedMap = new HashMap();
    EGLGraphicsDevice defaultDevice = new EGLGraphicsDevice("decon", 0);

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return abstractGraphicsDevice instanceof EGLGraphicsDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedResource getOrCreateShared(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource;
        String string = abstractGraphicsDevice.getConnection();
        HashMap hashMap = this.sharedMap;
        synchronized (hashMap) {
            sharedResource = (SharedResource)this.sharedMap.get(string);
        }
        if (null == sharedResource) {
            long l = EGL.eglGetDisplay(0L);
            if (l == 0L) {
                throw new GLException("Failed to created EGL default display: error 0x" + Integer.toHexString(EGL.eglGetError()));
            }
            if (DEBUG) {
                System.err.println("eglDisplay(EGL_DEFAULT_DISPLAY): 0x" + Long.toHexString(l));
            }
            if (!EGL.eglInitialize(l, null, null)) {
                throw new GLException("eglInitialize failed, error 0x" + Integer.toHexString(EGL.eglGetError()));
            }
            EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(l, string, abstractGraphicsDevice.getUnitID());
            sharedResource = new SharedResource(eGLGraphicsDevice);
            HashMap hashMap2 = this.sharedMap;
            synchronized (hashMap2) {
                this.sharedMap.put(string, sharedResource);
            }
            if (DEBUG) {
                System.err.println("!!! SharedDevice: " + eGLGraphicsDevice);
            }
        }
        return sharedResource;
    }

    @Override
    protected final GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null;
    }

    @Override
    protected AbstractGraphicsDevice getOrCreateSharedDeviceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateShared(abstractGraphicsDevice);
        if (null != sharedResource) {
            return sharedResource.getDevice();
        }
        return null;
    }

    SharedResource getOrCreateSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        return this.getOrCreateShared(abstractGraphicsDevice);
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        if (2 == n) {
            if (null == eglES2DynamicLookupHelper) {
                throw new GLException("GLDynamicLookupHelper for ES2 not available");
            }
            return eglES2DynamicLookupHelper;
        }
        if (1 == n) {
            if (null == eglES1DynamicLookupHelper) {
                throw new GLException("GLDynamicLookupHelper for ES1 not available");
            }
            return eglES1DynamicLookupHelper;
        }
        throw new GLException("Unsupported: ES" + n);
    }

    @Override
    protected final void shutdownInstance() {
    }

    @Override
    protected List getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return EGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new EGLOnscreenDrawable(this, nativeSurface);
    }

    @Override
    protected GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new GLException("Not yet implemented");
        }
        return new EGLPbufferDrawable(this, nativeSurface);
    }

    @Override
    public boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    @Override
    protected NativeSurface createOffscreenSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        ProxySurface proxySurface = new ProxySurface((AbstractGraphicsConfiguration)EGLGraphicsConfigurationFactory.createOffscreenGraphicsConfiguration(abstractGraphicsDevice, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser));
        proxySurface.setSize(n, n2);
        return proxySurface;
    }

    @Override
    protected GLContext createExternalGLContextImpl() {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault((String)"EGL");
        return new EGLExternalContext(abstractGraphicsScreen);
    }

    @Override
    public boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    protected GLDrawable createExternalGLDrawableImpl() {
        throw new GLException("Not yet implemented");
    }

    @Override
    public boolean canCreateContextOnJava2DSurface(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    public GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    static {
        GLDynamicLookupHelper gLDynamicLookupHelper;
        block10: {
            block9: {
                new EGLGraphicsConfigurationFactory();
                if ("X11".equals(NativeWindowFactory.getNativeWindowType((boolean)true))) {
                    try {
                        ReflectionUtil.createInstance((String)"jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory", (ClassLoader)EGLDrawableFactory.class.getClassLoader());
                    }
                    catch (JogampRuntimeException jogampRuntimeException) {
                        // empty catch block
                    }
                }
                gLDynamicLookupHelper = null;
                try {
                    gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES1DynamicLibraryBundleInfo());
                }
                catch (GLException gLException) {
                    if (!DEBUG) break block9;
                    gLException.printStackTrace();
                }
            }
            eglES1DynamicLookupHelper = gLDynamicLookupHelper;
            if (null != eglES1DynamicLookupHelper && eglES1DynamicLookupHelper.isLibComplete()) {
                EGL.resetProcAddressTable((DynamicLookupHelper)eglES1DynamicLookupHelper);
            }
            gLDynamicLookupHelper = null;
            try {
                gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES2DynamicLibraryBundleInfo());
            }
            catch (GLException gLException) {
                if (!DEBUG) break block10;
                gLException.printStackTrace();
            }
        }
        eglES2DynamicLookupHelper = gLDynamicLookupHelper;
        if (null != eglES2DynamicLookupHelper && eglES2DynamicLookupHelper.isLibComplete()) {
            EGL.resetProcAddressTable((DynamicLookupHelper)eglES2DynamicLookupHelper);
        }
    }

    static class SharedResource {
        private EGLGraphicsDevice device;

        SharedResource(EGLGraphicsDevice eGLGraphicsDevice) {
            this.device = eGLGraphicsDevice;
        }

        EGLGraphicsDevice getDevice() {
            return this.device;
        }
    }
}

