/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;

public class XColorRGB
implements Serializable {
    private float red;
    private float green;
    private float blue;

    public XColorRGB() {
    }

    public XColorRGB(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public float getBlue() {
        return this.blue;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public float getGreen() {
        return this.green;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public float getRed() {
        return this.red;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public XColorRGB(DataInputStreamLittleEndian is) throws IOException {
        this.red = is.readFloat();
        this.green = is.readFloat();
        this.blue = is.readFloat();
    }

    public void writeToStream(DataOutput os) throws IOException {
        os.writeFloat(this.red);
        os.writeFloat(this.green);
        os.writeFloat(this.blue);
    }

    public String toString() {
        return "{red = " + this.red + " green = " + this.green + " blue = " + this.green + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XColorRGB other = (XColorRGB)obj;
        if (Float.floatToIntBits(this.red) != Float.floatToIntBits(other.red)) {
            return false;
        }
        if (Float.floatToIntBits(this.green) != Float.floatToIntBits(other.green)) {
            return false;
        }
        return Float.floatToIntBits(this.blue) == Float.floatToIntBits(other.blue);
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Float.floatToIntBits(this.red);
        hash = 41 * hash + Float.floatToIntBits(this.green);
        hash = 41 * hash + Float.floatToIntBits(this.blue);
        return hash;
    }
}

