/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.InvalidVMDFileException;
import projectkyoto.mmd.file.VMDMotion;
import projectkyoto.mmd.file.VMDSkin;
import projectkyoto.mmd.file.util2.BufferUtil;

public class VMDFile
implements Serializable {
    private String vmdHeader;
    private String vmdModelName;
    private int motionCount;
    private int skinCount;
    private VMDSkin[] skinArray;
    protected final ArrayList<String> boneNames = new ArrayList();
    private ByteBuffer bb1;

    public VMDFile() {
        this.skinArray = new VMDSkin[0];
    }

    public VMDFile(URL url) throws IOException {
        this.read(url.openStream());
    }

    public VMDFile(InputStream is2) throws IOException {
        this.read(is2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream is2) throws IOException {
        FilterInputStream is = null;
        try {
            int i;
            is = new DataInputStreamLittleEndian(new BufferedInputStream(is2));
            this.vmdHeader = ((DataInputStreamLittleEndian)is).readString(30);
            if (!"Vocaloid Motion Data 0002".equals(this.vmdHeader)) {
                throw new InvalidVMDFileException();
            }
            this.vmdModelName = ((DataInputStreamLittleEndian)is).readString(20);
            this.motionCount = ((DataInputStreamLittleEndian)is).readInt();
            this.bb1 = BufferUtil.createByteBuffer(98 * this.motionCount);
            VMDMotion motion = new VMDMotion();
            motion.vmdFile = this;
            Integer[] indexes = new Integer[this.motionCount];
            for (int i2 = 0; i2 < this.motionCount; ++i2) {
                motion.readFromStream((DataInputStreamLittleEndian)is);
                motion.writeToBuffer(this.bb1);
                indexes[i2] = i2;
            }
            Arrays.sort(indexes, new VMDComparator());
            ByteBuffer bb2 = BufferUtil.createByteBuffer(98 * this.motionCount);
            for (i = 0; i < this.motionCount; ++i) {
                this.getMotion(motion, indexes[i]);
                bb2.position(98 * i);
                motion.writeToBuffer(bb2);
            }
            this.bb1 = bb2;
            this.skinCount = ((DataInputStreamLittleEndian)is).readInt();
            this.skinArray = new VMDSkin[this.skinCount];
            for (i = 0; i < this.skinCount; ++i) {
                this.skinArray[i] = new VMDSkin((DataInputStreamLittleEndian)is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{vmdHeader = ").append(this.vmdHeader).append("\n");
        sb.append("vmdModelName = ").append(this.vmdModelName).append("\n");
        sb.append("motionCount = ").append(this.motionCount).append("\n");
        sb.append("motionArray = {\n");
        VMDMotion m = new VMDMotion();
        for (int i = 0; i < this.motionCount; ++i) {
            m.readFromBuffer(this.bb1);
            sb.append(m).append("\n");
        }
        sb.append("}\n");
        sb.append("skinCount = ").append(this.skinCount).append("\n");
        sb.append("skinArray = {\n");
        for (VMDSkin skin : this.skinArray) {
            sb.append(skin).append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public synchronized VMDMotion getMotion(VMDMotion m, int i) {
        m.vmdFile = this;
        this.bb1.position(98 * i);
        m.readFromBuffer(this.bb1);
        return m;
    }

    public int getMotionCount() {
        return this.motionCount;
    }

    public void setMotionCount(int motionCount) {
        this.motionCount = motionCount;
    }

    public VMDSkin[] getSkinArray() {
        return this.skinArray;
    }

    public void setSkinArray(VMDSkin[] skinArray) {
        this.skinArray = skinArray;
    }

    public int getSkinCount() {
        return this.skinCount;
    }

    public void setSkinCount(int skinCount) {
        this.skinCount = skinCount;
    }

    public String getVmdHeader() {
        return this.vmdHeader;
    }

    public void setVmdHeader(String vmdHeader) {
        this.vmdHeader = vmdHeader;
    }

    public String getVmdModelName() {
        return this.vmdModelName;
    }

    public void setVmdModelName(String vmdModelName) {
        this.vmdModelName = vmdModelName;
    }

    class VMDComparator
    implements Comparator<Integer> {
        VMDMotion m1 = new VMDMotion();
        VMDMotion m2 = new VMDMotion();

        VMDComparator() {
        }

        @Override
        public int compare(Integer t, Integer t1) {
            VMDFile.this.getMotion(this.m1, t);
            VMDFile.this.getMotion(this.m2, t1);
            if (this.m1.getFrameNo() < this.m2.getFrameNo()) {
                return -1;
            }
            if (this.m1.getFrameNo() == this.m2.getFrameNo()) {
                return 0;
            }
            return 1;
        }
    }
}

