/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class DataInputStreamLittleEndian
extends FilterInputStream
implements DataInput {
    private DataInputStream dis;
    byte[] buf;

    public DataInputStreamLittleEndian(InputStream in) {
        super(in);
        this.dis = new DataInputStream(in);
    }

    public DataInputStreamLittleEndian(URL url) throws IOException {
        super(new BufferedInputStream(url.openStream()));
        this.dis = new DataInputStream(this);
    }

    final byte[] getBuf(int size) {
        if (this.buf == null || this.buf.length < size) {
            this.buf = new byte[size];
        }
        return this.buf;
    }

    @Override
    public final int readInt() throws IOException {
        return Integer.reverseBytes(this.dis.readInt());
    }

    @Override
    public final short readShort() throws IOException {
        return Short.reverseBytes(this.dis.readShort());
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int shortValue;
        int intValue = shortValue = this.readShort();
        return intValue &= 0xFFFF;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int byteValue;
        int intValue = byteValue = this.readByte();
        return intValue &= 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        return Long.reverseBytes(this.dis.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readString(int size) throws IOException {
        byte[] buf = this.getBuf(size);
        for (int pos = 0; pos < size; pos += this.read(buf, pos, size - pos)) {
        }
        for (int i = 0; i < size; ++i) {
            if (buf[i] != 0) continue;
            return new String(buf, 0, i, "Shift_JIS").intern();
        }
        return new String(buf, 0, size, "Shift_JIS").intern();
    }

    @Override
    public final byte readByte() throws IOException {
        byte[] buf = this.getBuf(1);
        this.read(buf, 0, 1);
        return buf[0];
    }

    @Override
    public long skip(long l) throws IOException {
        long l3;
        for (long l2 = l; l2 > 0L; l2 -= l3) {
            l3 = this.dis.skip(l2);
            if (l3 != 0L) continue;
            break;
        }
        return l;
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.dis.readFully(bytes);
    }

    @Override
    public void readFully(byte[] bytes, int i, int i1) throws IOException {
        this.dis.readFully(bytes, i, i1);
    }

    @Override
    public int skipBytes(int i) throws IOException {
        return this.dis.skipBytes(i);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    @Override
    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    @Override
    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }
}

