/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.helloworld;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyImageMode;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.tools.TimeProvider;

public class ScrollingPanel
implements EffectImpl {
    private TimeProvider timeProvider;
    private long start;
    private float xspeed;
    private float yspeed;
    private NiftyImage image;
    private float xoff;
    private float yoff;

    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.timeProvider = nifty.getTimeProvider();
        this.start = this.timeProvider.getMsTime();
        this.xspeed = Float.valueOf(parameter.getProperty("xspeed", "1000")).floatValue();
        this.yspeed = Float.valueOf(parameter.getProperty("yspeed", "1000")).floatValue();
        this.image = nifty.getRenderEngine().createImage(parameter.getProperty("filename"), false);
        String imageMode = parameter.getProperty("imageMode", null);
        if (imageMode != null) {
            this.image.setImageMode((ImageMode)NiftyImageMode.valueOf((String)imageMode));
        }
        this.xoff = 0.0f;
        this.yoff = 0.0f;
    }

    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        long now = this.timeProvider.getMsTime();
        r.saveState(null);
        this.xoff = (float)(now - this.start) % this.xspeed / this.xspeed * (float)this.image.getWidth() % (float)this.image.getWidth();
        this.yoff = (float)(now - this.start) % this.yspeed / this.yspeed * (float)this.image.getHeight() % (float)this.image.getHeight();
        r.enableClip(element.getX(), element.getY(), element.getX() + element.getWidth(), element.getY() + element.getHeight());
        r.renderImage(this.image, element.getX() + (int)this.xoff - this.image.getWidth(), element.getY() + (int)this.yoff - this.image.getHeight(), element.getWidth() - (int)this.xoff + this.image.getWidth(), element.getHeight() - (int)this.yoff + this.image.getHeight());
        r.restoreState();
    }

    public void deactivate() {
        this.image.dispose();
    }
}

