/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.examples.defaultcontrols.LoggerShortFormat;
import de.lessvoid.nifty.renderer.lwjgl.input.LwjglInputSystem;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class LwjglInitHelper {
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 768;
    private static Logger log = Logger.getLogger(LwjglInitHelper.class.getName());
    private static LwjglInputSystem inputSystem;

    public static LwjglInputSystem getInputSystem() {
        return inputSystem;
    }

    public static boolean initSubSystems(String title) {
        LoggerShortFormat.intialize();
        if (!LwjglInitHelper.initGraphics(title)) {
            return false;
        }
        return LwjglInitHelper.initInput();
    }

    private static boolean initGraphics(String title) {
        int width = 1920;
        int height = 1200;
        try {
            DisplayMode currentMode = Display.getDisplayMode();
            log.fine("currentmode: " + currentMode.getWidth() + ", " + currentMode.getHeight() + ", " + currentMode.getBitsPerPixel() + ", " + currentMode.getFrequency());
            width = currentMode.getWidth();
            height = currentMode.getHeight();
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            log.fine("Found " + modes.length + " display modes");
            ArrayList<DisplayMode> matching = new ArrayList<DisplayMode>();
            for (int i = 0; i < modes.length; ++i) {
                DisplayMode mode = modes[i];
                if (mode.getWidth() != 1024 || mode.getHeight() != 768 || mode.getBitsPerPixel() != 32) continue;
                log.fine(mode.getWidth() + ", " + mode.getHeight() + ", " + mode.getBitsPerPixel() + ", " + mode.getFrequency());
                matching.add(mode);
            }
            DisplayMode[] matchingModes = matching.toArray(new DisplayMode[0]);
            boolean found = false;
            for (int i = 0; i < matchingModes.length; ++i) {
                if (matchingModes[i].getFrequency() != currentMode.getFrequency()) continue;
                log.fine("using mode: " + matchingModes[i].getWidth() + ", " + matchingModes[i].getHeight() + ", " + matchingModes[i].getBitsPerPixel() + ", " + matchingModes[i].getFrequency());
                Display.setDisplayMode((DisplayMode)matchingModes[i]);
                found = true;
                break;
            }
            if (!found) {
                Arrays.sort(matchingModes, new Comparator<DisplayMode>(){

                    @Override
                    public int compare(DisplayMode o1, DisplayMode o2) {
                        if (o1.getFrequency() > o2.getFrequency()) {
                            return 1;
                        }
                        if (o1.getFrequency() < o2.getFrequency()) {
                            return -1;
                        }
                        return 0;
                    }
                });
                DisplayMode[] arr$ = matchingModes;
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    DisplayMode mode = arr$[i$];
                    log.fine("using fallback mode: " + mode.getWidth() + ", " + mode.getHeight() + ", " + mode.getBitsPerPixel() + ", " + mode.getFrequency());
                    Display.setDisplayMode((DisplayMode)mode);
                }
            }
            int x = (width - Display.getDisplayMode().getWidth()) / 2;
            int y = (height - Display.getDisplayMode().getHeight()) / 2;
            Display.setLocation((int)x, (int)y);
            try {
                Display.setFullscreen((boolean)false);
                Display.create();
                Display.setVSyncEnabled((boolean)false);
                Display.setTitle((String)title);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warning("Unable to create window!, exiting...");
                System.exit(-1);
            }
            log.info("Width: " + Display.getDisplayMode().getWidth() + ", Height: " + Display.getDisplayMode().getHeight() + ", Bits per pixel: " + Display.getDisplayMode().getBitsPerPixel() + ", Frequency: " + Display.getDisplayMode().getFrequency() + ", Title: " + Display.getTitle());
            log.info("plattform: " + LWJGLUtil.getPlatformName());
            log.info("opengl version: " + GL11.glGetString((int)7938));
            log.info("opengl vendor: " + GL11.glGetString((int)7936));
            log.info("opengl renderer: " + GL11.glGetString((int)7937));
            String extensions = GL11.glGetString((int)7939);
            if (extensions != null) {
                String[] ext = extensions.split(" ");
                for (int i = 0; i < ext.length; ++i) {
                    log.fine("opengl extensions: " + ext[i]);
                }
            }
            IntBuffer viewportBuffer = BufferUtils.createIntBuffer((int)16);
            GL11.glGetInteger((int)2978, (IntBuffer)viewportBuffer);
            int viewportWidth = viewportBuffer.get(2);
            int viewportHeight = viewportBuffer.get(3);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)viewportWidth, (double)viewportHeight, (double)0.0, (double)-9999.0, (double)9999.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)517, (float)0.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16384);
            GL11.glEnable((int)3553);
            return true;
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean initInput() {
        try {
            inputSystem = new LwjglInputSystem();
            inputSystem.startup();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warning("Unable to create keyboard!, exiting...");
            return false;
        }
    }

    public static void renderLoop(Nifty nifty, RenderLoopCallback callback) {
        boolean done = false;
        while (!Display.isCloseRequested() && !done) {
            if (callback != null) {
                callback.process();
            }
            Display.update();
            if (nifty.update()) {
                done = true;
            }
            nifty.render(true);
            int error = GL11.glGetError();
            if (error == 0) continue;
            String glerrmsg = GLU.gluErrorString((int)error);
            log.warning("OpenGL Error: (" + error + ") " + glerrmsg);
        }
    }

    public static void destroy() {
        inputSystem.shutdown();
        Display.destroy();
        System.exit(0);
    }

    public static interface RenderLoopCallback {
        public void process();
    }
}

