/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ProjectSelection.java
 *
 * Created on 02.07.2011, 15:08:08
 */
package com.jme3.gde.assetpack.actions;

import com.jme3.gde.assetpack.project.AssetPackProject;
import com.jme3.gde.core.assets.ProjectAssetManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;

/**
 *
 * @author normenhansen
 */
public class ProjectSelection extends javax.swing.JDialog {

    private List<Project> projects;
    private int selected = 0;

    /** Creates new form ProjectSelection */
    public ProjectSelection(List<Project> projects) {
        super(new JFrame(), true);
        initComponents();
        setLocationRelativeTo(null);
        this.projects = projects;
        jComboBox1.removeAllItems();
        for (Iterator<Project> it = projects.iterator(); it.hasNext();) {
            Project project = it.next();
            ProjectInformation info = project.getLookup().lookup(ProjectInformation.class);
            jComboBox1.addItem(info.getName());
        }
    }

    public Project getSelected() {
        return projects.get(selected);
    }

    public static Project showProjectSelection() {
        List<Project> validProjects = new ArrayList<Project>();
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (Project project : projects) {
            if (!(project instanceof AssetPackProject) && project.getLookup().lookup(ProjectAssetManager.class) != null) {
                validProjects.add(project);
            }
        }
        if (validProjects.size() == 1) {
            return validProjects.get(0);
        }
        ProjectSelection sel = new ProjectSelection(validProjects);
        sel.setVisible(true);
        return sel.getSelected();
    }

    public static ProjectAssetManager getProjectAssetManager() {
        Project proj = showProjectSelection();
        if (proj == null) {
            return null;
        } else {
            return proj.getLookup().lookup(ProjectAssetManager.class);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jComboBox1 = new javax.swing.JComboBox();
        jButton1 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        jButton1.setText(org.openide.util.NbBundle.getMessage(ProjectSelection.class, "ProjectSelection.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jComboBox1, 0, 227, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButton1))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jButton1))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        selected = jComboBox1.getSelectedIndex();
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        setVisible(false);
    }//GEN-LAST:event_jButton1ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JComboBox jComboBox1;
    // End of variables declaration//GEN-END:variables
}
