/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield;

import de.lessvoid.nifty.Clipboard;
import de.lessvoid.nifty.controls.textfield.TextFieldView;
import de.lessvoid.nifty.controls.textfield.filter.delete.FilterDeleteAll;
import de.lessvoid.nifty.controls.textfield.filter.delete.TextFieldDeleteFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptAll;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputCharFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputCharSequenceFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputFilter;
import de.lessvoid.nifty.controls.textfield.format.FormatPassword;
import de.lessvoid.nifty.controls.textfield.format.FormatPlain;
import de.lessvoid.nifty.controls.textfield.format.TextFieldDisplayFormat;

public class TextFieldLogic {
    private final StringBuilder text;
    private int cursorPosition;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private boolean selecting;
    private int selectionStartIndex;
    private final Clipboard clipboard;
    private int maxLength;
    private final TextFieldView view;
    private TextFieldInputCharFilter filterInputSingle;
    private TextFieldInputCharSequenceFilter filterInputSequence;
    private TextFieldDeleteFilter filterDelete;
    private static final TextFieldInputFilter DEFAULT_INPUT_FILTER = new FilterAcceptAll();
    private static final TextFieldDeleteFilter DEFAULT_DELETE_FILTER = new FilterDeleteAll();
    private TextFieldDisplayFormat format;

    public TextFieldLogic(CharSequence newText, Clipboard newClipboard, TextFieldView textFieldView) {
        this.view = textFieldView;
        this.clipboard = newClipboard;
        this.maxLength = -1;
        this.filterInputSingle = DEFAULT_INPUT_FILTER;
        this.filterInputSequence = DEFAULT_INPUT_FILTER;
        this.filterDelete = DEFAULT_DELETE_FILTER;
        this.format = new FormatPlain();
        this.text = new StringBuilder(100);
        this.setText(newText);
    }

    public void setText(CharSequence newText) {
        this.text.setLength(0);
        if (newText != null) {
            this.text.append(newText);
        }
        this.cursorPosition = 0;
        this.resetSelection();
    }

    public void setInputFilterSingle(TextFieldInputCharFilter filter) {
        this.filterInputSingle = filter == null ? DEFAULT_INPUT_FILTER : filter;
    }

    public void setInputFilterSequence(TextFieldInputCharSequenceFilter filter) {
        this.filterInputSequence = filter == null ? DEFAULT_INPUT_FILTER : filter;
    }

    public void setDeleteFilter(TextFieldDeleteFilter filter) {
        this.filterDelete = filter == null ? DEFAULT_DELETE_FILTER : filter;
    }

    public void setFormat(TextFieldDisplayFormat newFormat) {
        this.format = newFormat == null ? new FormatPlain() : newFormat;
    }

    public TextFieldDisplayFormat getFormat() {
        return this.format;
    }

    public void resetSelection() {
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.selecting = false;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public void backspace() {
        if (this.hasSelection()) {
            this.delete();
        } else if (this.cursorPosition > 0) {
            this.cursorLeft();
            this.delete();
        }
    }

    public void cursorLeft() {
        this.moveCursor(-1);
    }

    private void moveCursor(int direction) {
        this.setCursorPosition(this.cursorPosition + direction);
    }

    private void selectionFromCursorPosition() {
        if (!this.selecting || this.cursorPosition == this.selectionStartIndex) {
            this.resetSelection();
        } else if (this.cursorPosition > this.selectionStartIndex) {
            this.selectionStart = this.selectionStartIndex;
            this.selectionEnd = this.cursorPosition;
        } else {
            this.selectionStart = this.cursorPosition;
            this.selectionEnd = this.selectionStartIndex;
        }
    }

    public void delete() {
        if (this.hasSelection()) {
            this.deleteSelectedText();
        } else if (this.cursorPosition < this.text.length() && this.filterDelete.acceptDelete(this.text, this.cursorPosition, this.cursorPosition + 1)) {
            this.text.delete(this.cursorPosition, this.cursorPosition + 1);
        } else {
            return;
        }
        this.view.textChangeEvent(this.text.toString());
    }

    public boolean hasSelection() {
        return this.selectionStart != -1 && this.selectionEnd != -1;
    }

    private void deleteSelectedText() {
        if (!this.hasSelection()) {
            throw new IllegalStateException("Can't delete selected text without selection");
        }
        if (this.filterDelete.acceptDelete(this.text, this.selectionStart, this.selectionEnd)) {
            this.text.delete(this.selectionStart, this.selectionEnd);
            this.cursorPosition = this.selectionStart;
            this.resetSelection();
        }
    }

    public void copy() {
        CharSequence selectedText = this.getDisplayedSelectedText();
        if (selectedText != null) {
            this.clipboard.put(selectedText.toString());
        }
    }

    public void cursorRight() {
        this.moveCursor(1);
    }

    public void cut() {
        CharSequence selectedText = this.getDisplayedSelectedText();
        if (selectedText == null) {
            return;
        }
        this.clipboard.put(selectedText.toString());
        this.delete();
    }

    public CharSequence getDisplayedSelectedText() {
        if (!this.hasSelection()) {
            return null;
        }
        return this.format.getDisplaySequence(this.text, this.selectionStart, this.selectionEnd);
    }

    public void endSelecting() {
        this.selecting = false;
    }

    public CharSequence getDisplayedText() {
        return this.format.getDisplaySequence(this.text, 0, this.text.length());
    }

    public CharSequence getRealText() {
        return this.text;
    }

    public Character getPasswordChar() {
        if (this.format instanceof FormatPassword) {
            return Character.valueOf(((FormatPassword)this.format).getPasswordChar());
        }
        return null;
    }

    public CharSequence getRealSelectedText() {
        if (!this.hasSelection()) {
            return null;
        }
        return this.text.subSequence(this.selectionStart, this.selectionEnd);
    }

    public int getSelectionLength() {
        if (this.hasSelection()) {
            return this.selectionEnd - this.selectionStart;
        }
        return 0;
    }

    public void setTextAndNotify(CharSequence newText) {
        this.setText(newText);
        if (newText != null && newText.length() > 0) {
            this.view.textChangeEvent(newText.toString());
        }
    }

    private boolean filterAndInsert(char c) {
        if ((this.maxLength == -1 || this.text.length() < this.maxLength) && this.filterInputSingle.acceptInput(this.cursorPosition, c)) {
            this.text.insert(this.cursorPosition, c);
            ++this.cursorPosition;
            return true;
        }
        return false;
    }

    private boolean filterAndInsert(CharSequence chars) {
        if (chars.length() == 0) {
            return false;
        }
        if (this.maxLength == -1 || this.text.length() < this.maxLength) {
            int insertCnt = this.maxLength == -1 ? chars.length() : Math.min(this.maxLength - this.text.length(), chars.length());
            CharSequence insertSequence = chars.subSequence(0, insertCnt);
            if (this.filterInputSequence.acceptInput(this.cursorPosition, insertSequence)) {
                this.text.insert(this.cursorPosition, chars);
                this.cursorPosition += insertCnt;
                return true;
            }
            int length = chars.length();
            boolean result = false;
            for (int i = 0; i < length; ++i) {
                if (!this.filterAndInsert(chars.charAt(i))) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    public void insert(char c) {
        if (this.hasSelection()) {
            this.deleteSelectedText();
        }
        if (this.filterAndInsert(c)) {
            this.view.textChangeEvent(this.text.toString());
        }
    }

    public void put() {
        String clipboardText = this.clipboard.get();
        if (clipboardText != null) {
            this.insert(this.filterNewLines(clipboardText));
        }
    }

    public void insert(CharSequence chars) {
        if (this.hasSelection()) {
            this.deleteSelectedText();
        }
        if (this.filterAndInsert(chars)) {
            this.view.textChangeEvent(this.text.toString());
        }
    }

    public void selectAll() {
        this.selectionStartIndex = 0;
        this.selectionStart = 0;
        this.selectionEnd = this.text.length();
        this.cursorPosition = this.text.length();
    }

    public void setMaxLength(int maxLen) {
        this.maxLength = maxLen;
        if (this.maxLength != -1 && this.text.length() > maxLen) {
            this.text.setLength(maxLen);
            this.setCursorPosition(Math.min(this.cursorPosition, this.text.length()));
            this.view.textChangeEvent(this.text.toString());
        }
    }

    public void setCursorPosition(int newIndex) {
        int clampedIndex = Math.max(0, Math.min(newIndex, this.text.length()));
        if (this.cursorPosition != clampedIndex) {
            this.cursorPosition = clampedIndex;
            this.selectionFromCursorPosition();
        }
    }

    public void startSelecting() {
        this.selecting = true;
        this.selectionStartIndex = this.cursorPosition;
    }

    public void toFirstPosition() {
        this.setCursorPosition(0);
    }

    public void toLastPosition() {
        this.setCursorPosition(Integer.MAX_VALUE);
    }

    private CharSequence filterNewLines(String input) {
        return input.replaceAll("\\r\\n|\\r|\\n", "");
    }
}

