/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.resolution;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.DropDownSelectionChangedEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.examples.resolution.ResolutionControl;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.util.Collection;

public class ResolutionScreen<T>
implements ScreenController,
NiftyExample {
    private Nifty nifty;
    private Screen screen;
    private DropDown<T> dropDown;
    private ListBox<String> listBox;
    private ResolutionControl<T> resControl;

    public ResolutionScreen(ResolutionControl<T> newControl) {
        this.resControl = newControl;
    }

    public void bind(Nifty newNifty, Screen newScreen) {
        this.nifty = newNifty;
        this.screen = newScreen;
        this.dropDown = (DropDown)this.screen.findNiftyControl("resolutions", DropDown.class);
        this.listBox = (ListBox)this.screen.findNiftyControl("listBox", ListBox.class);
        this.fillResolutionDropDown(this.screen);
        this.dropDown.selectItem(this.resControl.getCurrentResolution());
        this.listBox.addItem((Object)"Test");
        this.listBox.addItem((Object)"TestTestTestTestTestTestTestTestTestTestTestTest");
        this.listBox.selectItem((Object)"Test");
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="resolutions")
    public void onResolution(String id, DropDownSelectionChangedEvent<T> event) {
        this.resControl.setResolution(event.getSelection());
        this.nifty.resolutionChanged();
    }

    private void fillResolutionDropDown(Screen screen) {
        Collection<T> resolutions = this.resControl.getResolutions();
        for (T mode : resolutions) {
            this.dropDown.addItem(mode);
        }
    }

    @Override
    public String getStartScreen() {
        return "start";
    }

    @Override
    public String getMainXML() {
        return "resolution/resolution.xml";
    }

    @Override
    public String getTitle() {
        return "Nifty Screen Resolution";
    }

    @Override
    public void prepareStart(Nifty nifty) {
        nifty.registerScreenController(new ScreenController[]{this});
    }
}

