/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementBase;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.MeasurementVisitor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.NullMeasurement;
import com.jeantessier.metrics.StatisticalMeasurement;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class NbSubMetricsMeasurement
extends MeasurementBase {
    private static final String LESSER_THAN = "<";
    private static final String LESSER_THAN_OR_EQUAL = "<=";
    private static final String GREATER_THAN = ">";
    private static final String GREATER_THAN_OR_EQUAL = ">=";
    private static final String EQUALS = "==";
    private static final String NOT_EQUALS = "!=";
    private static final String OPERATORS_REGULAR_EXPRESSION = "/(<=)|(<)|(>=)|(>)|(==)|(!=)/";
    private static final double DELTA = 0.1;
    private List<String> terms = new LinkedList<String>();
    private int value = 0;

    public NbSubMetricsMeasurement(MeasurementDescriptor descriptor, Metrics context, String initText) {
        super(descriptor, context, initText);
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(initText));
            while ((line = in.readLine()) != null) {
                this.terms.add(line.trim());
            }
            in.close();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass()).debug((Object)("Cannot initialize with \"" + initText + "\""), (Throwable)ex);
            this.terms.clear();
        }
    }

    public List<String> getTerms() {
        return this.terms;
    }

    @Override
    public void accept(MeasurementVisitor visitor) {
        visitor.visitNbSubMetricsMeasurement(this);
    }

    @Override
    public boolean isEmpty() {
        if (!this.isCached()) {
            this.compute();
        }
        return super.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double compute() {
        if (!this.isCached()) {
            NbSubMetricsMeasurement nbSubMetricsMeasurement = this;
            synchronized (nbSubMetricsMeasurement) {
                if (!this.isCached()) {
                    this.value = 0;
                    if (this.getTerms().isEmpty()) {
                        this.value = this.getContext().getSubMetrics().size();
                    } else {
                        for (Metrics metrics : this.getContext().getSubMetrics()) {
                            if (!this.getSelectMetrics(metrics)) continue;
                            ++this.value;
                        }
                    }
                    this.setEmpty(this.value == 0);
                    this.setCached(true);
                }
            }
        }
        return this.value;
    }

    private boolean getSelectMetrics(Metrics metrics) {
        boolean result = this.getTerms().isEmpty();
        Iterator<String> i = this.getTerms().iterator();
        while (!result && i.hasNext()) {
            result = this.evaluateTerm(i.next(), metrics);
        }
        return result;
    }

    private boolean evaluateTerm(String term, Metrics metrics) {
        boolean result;
        Logger.getLogger(this.getClass()).debug((Object)("EvaluateTerm(\"" + term + "\", " + metrics + ")"));
        ArrayList elements = new ArrayList();
        NbSubMetricsMeasurement.perl().split(elements, OPERATORS_REGULAR_EXPRESSION, term);
        boolean bl = result = elements.size() > 0 && elements.size() % 2 == 1;
        if (elements.size() == 1) {
            result = metrics.hasMeasurement((String)elements.remove(0));
        } else {
            while (result && elements.size() > 2 && elements.size() % 2 == 1) {
                String leftString = (String)elements.remove(0);
                String operator = (String)elements.remove(0);
                String rightString = (String)elements.get(0);
                double leftOperand = 0.0;
                try {
                    leftOperand = Double.parseDouble(leftString);
                }
                catch (NumberFormatException ex) {
                    try {
                        leftOperand = this.resolveOperand(leftString, metrics);
                    }
                    catch (NullPointerException ex2) {
                        result = false;
                    }
                }
                double rightOperand = 0.0;
                try {
                    rightOperand = Double.parseDouble(rightString);
                }
                catch (NumberFormatException ex) {
                    try {
                        rightOperand = this.resolveOperand(rightString, metrics);
                    }
                    catch (NullPointerException ex2) {
                        result = false;
                    }
                }
                if (!result) continue;
                if (operator.equals(LESSER_THAN)) {
                    result = leftOperand < rightOperand;
                    continue;
                }
                if (operator.equals(LESSER_THAN_OR_EQUAL)) {
                    result = leftOperand <= rightOperand;
                    continue;
                }
                if (operator.equals(GREATER_THAN)) {
                    result = leftOperand > rightOperand;
                    continue;
                }
                if (operator.equals(GREATER_THAN_OR_EQUAL)) {
                    result = leftOperand >= rightOperand;
                    continue;
                }
                if (operator.equals(EQUALS)) {
                    result = Math.abs(leftOperand - rightOperand) <= 0.1;
                    continue;
                }
                if (!operator.equals(NOT_EQUALS)) continue;
                result = Math.abs(leftOperand - rightOperand) > 0.1;
            }
        }
        Logger.getLogger(this.getClass()).debug((Object)("EvaluateTerm(\"" + term + "\", " + metrics + "): " + result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double resolveOperand(String name, Metrics metrics) {
        double result = 0.0;
        name = name.trim();
        Logger.getLogger(this.getClass()).debug((Object)("ResolveOperand(\"" + name + "\", " + metrics + ")"));
        if (name.length() != 0) {
            int dispose;
            Perl5Util perl5Util = NbSubMetricsMeasurement.perl();
            synchronized (perl5Util) {
                if (NbSubMetricsMeasurement.perl().match("/(.*)\\s+(dispose_\\w+)$/i", name)) {
                    name = NbSubMetricsMeasurement.perl().group(1);
                    String disposeText = NbSubMetricsMeasurement.perl().group(2);
                    dispose = disposeText.equalsIgnoreCase("DISPOSE_IGNORE") ? 0 : (disposeText.equalsIgnoreCase("DISPOSE_MINIMUM") ? 1 : (disposeText.equalsIgnoreCase("DISPOSE_MEDIAN") ? 2 : (disposeText.equalsIgnoreCase("DISPOSE_AVERAGE") ? 3 : (disposeText.equalsIgnoreCase("DISPOSE_STANDARD_DEVIATION") ? 4 : (disposeText.equalsIgnoreCase("DISPOSE_MAXIMUM") ? 5 : (disposeText.equalsIgnoreCase("DISPOSE_SUM") ? 6 : (disposeText.equalsIgnoreCase("DISPOSE_NB_DATA_POINTS") ? 7 : 0)))))));
                } else {
                    dispose = 0;
                }
            }
            Measurement measurement = metrics.getMeasurement(name);
            if (measurement instanceof StatisticalMeasurement) {
                StatisticalMeasurement stats = (StatisticalMeasurement)measurement;
                switch (dispose) {
                    case 1: {
                        result = stats.getMinimum();
                        break;
                    }
                    case 2: {
                        result = stats.getMedian();
                        break;
                    }
                    case 3: {
                        result = stats.getAverage();
                        break;
                    }
                    case 4: {
                        result = stats.getStandardDeviation();
                        break;
                    }
                    case 5: {
                        result = stats.getMaximum();
                        break;
                    }
                    case 6: {
                        result = stats.getSum();
                        break;
                    }
                    case 7: {
                        result = stats.getNbDataPoints();
                        break;
                    }
                    default: {
                        result = stats.getValue().doubleValue();
                        break;
                    }
                }
            } else {
                if (measurement instanceof NullMeasurement) {
                    throw new NullPointerException();
                }
                result = measurement.getValue().doubleValue();
            }
        }
        Logger.getLogger(this.getClass()).debug((Object)("ResolveOperand(\"" + name + "\", " + metrics + "): " + result));
        return result;
    }
}

