/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.StatisticalMeasurement;
import java.util.Comparator;

public class MetricsComparator
implements Comparator<Metrics> {
    public static final int DESCENDING = -1;
    public static final int ASCENDING = 1;
    private String name;
    private int direction;
    private int dispose;

    public MetricsComparator(String name) {
        this(name, 0);
    }

    public MetricsComparator(String name, int dispose) {
        this.setName(name);
        this.setDispose(dispose);
        this.setDirection(1);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDispose() {
        return this.dispose;
    }

    public void setDispose(int dispose) {
        this.dispose = dispose;
    }

    public void sortOn(String name, int dispose) {
        if (name.equals(this.name) && dispose == this.dispose) {
            this.reverse();
        } else {
            this.setName(name);
            this.setDirection(1);
            this.setDispose(dispose);
        }
    }

    public void reverse() {
        this.direction *= -1;
    }

    @Override
    public int compare(Metrics metrics1, Metrics metrics2) {
        int result;
        if ("name".equals(this.name)) {
            result = metrics1.getName().compareTo(metrics2.getName());
        } else {
            Measurement m1 = metrics1.getMeasurement(this.name);
            Measurement m2 = metrics2.getMeasurement(this.name);
            if (m1 == null && m2 != null) {
                result = -1;
            } else if (m1 != null && m2 == null) {
                result = 1;
            } else if (m1 == m2) {
                result = 0;
            } else {
                double v1 = this.extractValue(m1);
                double v2 = this.extractValue(m2);
                result = Double.isNaN(v1) && !Double.isNaN(v2) ? 1 * this.getDirection() : (!Double.isNaN(v1) && Double.isNaN(v2) ? -1 * this.getDirection() : (Double.isNaN(v1) && Double.isNaN(v2) ? 0 : (v1 < v2 ? -1 : (v1 > v2 ? 1 : 0))));
            }
        }
        return result *= this.getDirection();
    }

    private double extractValue(Measurement m) {
        double result = Double.NaN;
        if (m instanceof StatisticalMeasurement) {
            StatisticalMeasurement sm = (StatisticalMeasurement)m;
            switch (this.getDispose()) {
                case 1: {
                    result = sm.getMinimum();
                    break;
                }
                case 2: {
                    result = sm.getMedian();
                    break;
                }
                case 3: {
                    result = sm.getAverage();
                    break;
                }
                case 4: {
                    result = sm.getStandardDeviation();
                    break;
                }
                case 5: {
                    result = sm.getMaximum();
                    break;
                }
                case 6: {
                    result = sm.getSum();
                    break;
                }
                case 7: {
                    result = sm.getNbDataPoints();
                    break;
                }
            }
        } else {
            result = m.getValue().doubleValue();
        }
        return result;
    }
}

