/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.Printer;
import com.jeantessier.metrics.StatisticalMeasurement;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class CSVPrinter
extends Printer {
    private List<MeasurementDescriptor> descriptors;

    public CSVPrinter(PrintWriter out, List<MeasurementDescriptor> descriptors) {
        super(out);
        this.descriptors = descriptors;
        this.appendHeader();
    }

    private void appendHeader() {
        this.appendLongNames();
        this.appendShortNames();
        this.appendStatSubNames();
    }

    private void appendLongNames() {
        this.append("\"name\", ");
        Iterator<MeasurementDescriptor> i = this.descriptors.iterator();
        while (i.hasNext()) {
            MeasurementDescriptor descriptor = i.next();
            if (!descriptor.isVisible()) continue;
            if (descriptor.getClassFor().equals(StatisticalMeasurement.class)) {
                this.append("\"").append(descriptor.getLongName()).append("\", ");
                this.append("\"").append(descriptor.getLongName()).append("\", ");
                this.append("\"").append(descriptor.getLongName()).append("\", ");
                this.append("\"").append(descriptor.getLongName()).append("\", ");
                this.append("\"").append(descriptor.getLongName()).append("\", ");
                this.append("\"").append(descriptor.getLongName()).append("\", ");
                this.append("\"").append(descriptor.getLongName()).append("\"");
            } else {
                this.append("\"").append(descriptor.getLongName()).append("\"");
            }
            if (!i.hasNext()) continue;
            this.append(", ");
        }
        this.eol();
    }

    private void appendShortNames() {
        this.append(", ");
        Iterator<MeasurementDescriptor> i = this.descriptors.iterator();
        while (i.hasNext()) {
            MeasurementDescriptor descriptor = i.next();
            if (!descriptor.isVisible()) continue;
            if (descriptor.getClassFor().equals(StatisticalMeasurement.class)) {
                this.append("\"").append(descriptor.getShortName()).append("\", ");
                this.append("\"").append(descriptor.getShortName()).append("\", ");
                this.append("\"").append(descriptor.getShortName()).append("\", ");
                this.append("\"").append(descriptor.getShortName()).append("\", ");
                this.append("\"").append(descriptor.getShortName()).append("\", ");
                this.append("\"").append(descriptor.getShortName()).append("\", ");
                this.append("\"").append(descriptor.getShortName()).append("\"");
            } else {
                this.append("\"").append(descriptor.getShortName()).append("\"");
            }
            if (!i.hasNext()) continue;
            this.append(", ");
        }
        this.eol();
    }

    private void appendStatSubNames() {
        this.append(", ");
        Iterator<MeasurementDescriptor> i = this.descriptors.iterator();
        while (i.hasNext()) {
            MeasurementDescriptor descriptor = i.next();
            if (!descriptor.isVisible()) continue;
            if (descriptor.getClassFor().equals(StatisticalMeasurement.class)) {
                this.append("minimum, ");
                this.append("median, ");
                this.append("average, ");
                this.append("std dev, ");
                this.append("maxium, ");
                this.append("sum, ");
                this.append("nb");
            }
            if (!i.hasNext()) continue;
            this.append(", ");
        }
        this.eol();
    }

    @Override
    public void visitMetrics(Metrics metrics) {
        if (this.isShowEmptyMetrics() || this.isShowHiddenMeasurements() || !metrics.isEmpty()) {
            this.append("\"").append(metrics.getName()).append("\", ");
            Iterator<MeasurementDescriptor> i = this.descriptors.iterator();
            while (i.hasNext()) {
                MeasurementDescriptor descriptor = i.next();
                if (!this.isShowHiddenMeasurements() && !descriptor.isVisible()) continue;
                Measurement measurement = metrics.getMeasurement(descriptor.getShortName());
                measurement.accept(this);
                if (!i.hasNext()) continue;
                this.append(", ");
            }
            this.eol();
        }
    }

    @Override
    public void visitStatisticalMeasurement(StatisticalMeasurement measurement) {
        this.append(measurement.getMinimum()).append(", ");
        this.append(measurement.getMedian()).append(", ");
        this.append(measurement.getAverage()).append(", ");
        this.append(measurement.getStandardDeviation()).append(", ");
        this.append(measurement.getMaximum()).append(", ");
        this.append(measurement.getSum()).append(", ");
        this.append(measurement.getNbDataPoints());
    }

    @Override
    protected void visitMeasurement(Measurement measurement) {
        this.append(measurement.getValue());
    }
}

