/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependencyfinder.gui.OOMetricsTableModel;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.StatisticalMeasurement;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.apache.log4j.Logger;

class TableHeaderListener
implements MouseListener,
MouseMotionListener {
    private JTable table;
    private OOMetricsTableModel model;

    public TableHeaderListener(JTable table, OOMetricsTableModel model) {
        this.table = table;
        this.model = model;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int viewColumn = this.table.getColumnModel().getColumnIndexAtX(event.getX());
        int column = this.table.convertColumnIndexToModel(viewColumn);
        String columnName = this.model.getRawColumnName(column);
        int columnDispose = this.model.getRawColumnDispose(column);
        Logger.getLogger(this.getClass()).debug((Object)"mouseClicked");
        Logger.getLogger(this.getClass()).debug((Object)("event.getX()       = " + event.getX()));
        Logger.getLogger(this.getClass()).debug((Object)("view column        = " + viewColumn));
        Logger.getLogger(this.getClass()).debug((Object)("column             = " + column));
        Logger.getLogger(this.getClass()).debug((Object)("raw column name    = " + columnName));
        Logger.getLogger(this.getClass()).debug((Object)("raw column dispose = " + columnDispose));
        this.model.sortOn(columnName, columnDispose);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)"mouseEntered");
    }

    @Override
    public void mouseExited(MouseEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)"mouseExited");
    }

    @Override
    public void mousePressed(MouseEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)"mousePressed");
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)"mouseReleased");
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)"mouseDragged");
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (event.getComponent() instanceof JComponent) {
            JComponent component = (JComponent)event.getComponent();
            int viewColumn = this.table.getColumnModel().getColumnIndexAtX(event.getX());
            int column = this.table.convertColumnIndexToModel(viewColumn);
            MeasurementDescriptor descriptor = this.model.getColumnDescriptor(column);
            int columnDispose = this.model.getRawColumnDispose(column);
            String text = null;
            if (descriptor != null) {
                StringBuffer tooltip = new StringBuffer();
                tooltip.append("<html><body><p>");
                tooltip.append(descriptor.getLongName());
                if (descriptor.getClassFor().equals(StatisticalMeasurement.class)) {
                    switch (columnDispose) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            tooltip.append(", ").append(StatisticalMeasurement.getDisposeLabel(columnDispose));
                            break;
                        }
                    }
                }
                tooltip.append("<br>valid range: ").append(descriptor.getRangeAsString());
                tooltip.append("</p></body></html>");
                text = tooltip.toString();
            }
            component.setToolTipText(text);
        }
    }
}

