/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependency.VisitorBase;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.gui.DependencyFinder;
import com.jeantessier.dependencyfinder.gui.XMLFileFilter;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class SaveFileAction
extends AbstractAction
implements Runnable {
    private DependencyFinder model;
    private String encoding;
    private String dtdPrefix;
    private String indentText;
    private File file;

    public SaveFileAction(DependencyFinder model, String encoding, String dtdPrefix) {
        this.model = model;
        this.encoding = encoding;
        this.dtdPrefix = dtdPrefix;
        this.putValue("LongDescription", "Save current graph to XML file");
        this.putValue("Name", "Save");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/save.gif")));
    }

    public String getIndentText() {
        return this.indentText;
    }

    public void setIndentText(String indentText) {
        this.indentText = indentText;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new XMLFileFilter());
        int returnValue = chooser.showSaveDialog(this.model);
        if (returnValue == 0) {
            this.file = chooser.getSelectedFile();
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        try {
            this.model.getStatusLine().showInfo("Saving " + this.file.getName() + " ...");
            PrintWriter out = new PrintWriter(new FileWriter(this.file));
            XMLPrinter printer = new XMLPrinter(out, this.encoding, this.dtdPrefix);
            if (this.indentText != null) {
                printer.setIndentText(this.indentText);
            }
            ((VisitorBase)printer).traverseNodes(this.model.getPackages());
            out.close();
            this.model.getStatusLine().showInfo("Saved " + this.file.getName());
        }
        catch (IOException ex) {
            this.model.getStatusLine().showError("Cannot save: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }
}

