/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.dependency.DependencyEvent;
import com.jeantessier.dependency.DependencyListener;
import com.jeantessier.dependencyfinder.NullPrintWriter;
import com.jeantessier.dependencyfinder.VerboseListenerBase;
import com.jeantessier.metrics.MetricsEvent;
import com.jeantessier.metrics.MetricsListener;
import java.io.PrintWriter;
import java.io.Writer;

public class VerboseListener
extends VerboseListenerBase
implements DependencyListener,
MetricsListener {
    private PrintWriter writer = new NullPrintWriter();

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.setWriter(new PrintWriter(writer));
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void close() {
        this.getWriter().close();
    }

    public void print(String s) {
        this.getWriter().println(s);
    }

    @Override
    public void beginSession(LoadEvent event) {
        super.beginSession(event);
        this.getWriter().print("Searching for classes ...");
        this.getWriter().println();
        this.getWriter().flush();
    }

    @Override
    public void beginGroup(LoadEvent event) {
        super.beginGroup(event);
        this.getWriter().print("Searching ");
        this.getWriter().print(this.getCurrentGroup().getName());
        switch (this.getCurrentGroup().getSize()) {
            case -1: {
                break;
            }
            case 0: 
            case 1: {
                this.getWriter().print(" (");
                this.getWriter().print(this.getCurrentGroup().getSize());
                this.getWriter().print(" file)");
                break;
            }
            default: {
                this.getWriter().print(" (");
                this.getWriter().print(this.getCurrentGroup().getSize());
                this.getWriter().print(" files)");
            }
        }
        this.getWriter().print(" ...");
        this.getWriter().println();
        this.getWriter().flush();
    }

    @Override
    public void endClassfile(LoadEvent event) {
        super.endClassfile(event);
        this.getWriter().print("Loading ");
        this.getWriter().print(event.getClassfile());
        this.getWriter().print(" ...");
        this.getWriter().println();
        this.getWriter().flush();
    }

    @Override
    public void endFile(LoadEvent event) {
        super.endFile(event);
        if (!this.getVisitedFiles().contains(event.getFilename())) {
            this.getWriter().print("Skipping ");
            this.getWriter().print(event.getFilename());
            this.getWriter().print(" ...");
            this.getWriter().println();
            this.getWriter().flush();
        }
    }

    @Override
    public void beginSession(DependencyEvent event) {
    }

    @Override
    public void beginClass(DependencyEvent event) {
        this.getWriter().print("Getting dependencies from ");
        this.getWriter().print(event.getClassName());
        this.getWriter().print(" ...");
        this.getWriter().println();
        this.getWriter().flush();
    }

    @Override
    public void dependency(DependencyEvent event) {
    }

    @Override
    public void endClass(DependencyEvent event) {
    }

    @Override
    public void endSession(DependencyEvent event) {
    }

    @Override
    public void beginSession(MetricsEvent event) {
    }

    @Override
    public void beginClass(MetricsEvent event) {
        this.getWriter().print("Computing metrics for ");
        this.getWriter().print(event.getClassfile());
        this.getWriter().print(" ...");
        this.getWriter().println();
        this.getWriter().flush();
    }

    @Override
    public void beginMethod(MetricsEvent event) {
    }

    @Override
    public void endMethod(MetricsEvent event) {
    }

    @Override
    public void endClass(MetricsEvent event) {
    }

    @Override
    public void endSession(MetricsEvent event) {
    }
}

