/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.Printer;
import com.jeantessier.classreader.TextPrinter;
import com.jeantessier.classreader.XMLPrinter;
import com.jeantessier.commandline.AtLeastParameterStrategy;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.dependencyfinder.cli.Command;
import java.io.PrintStream;

public class ClassReader
extends Command {
    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd", "    ");
        this.getCommandLine().addToggleSwitch("xml");
    }

    @Override
    protected ParameterStrategy getParameterStrategy() {
        return new AtLeastParameterStrategy(1);
    }

    @Override
    protected void showSpecificUsage(PrintStream out) {
    }

    @Override
    protected void doProcessing() throws Exception {
        AggregatingClassfileLoader loader = new AggregatingClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        loader.load(this.getCommandLine().getParameters());
        Printer printer = this.getCommandLine().getToggleSwitch("xml") ? new XMLPrinter(this.getOut(), this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextPrinter(this.getOut());
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        printer.visitClassfiles(((ClassfileLoader)loader).getAllClassfiles());
    }

    public static void main(String[] args) throws Exception {
        new ClassReader().run(args);
    }
}

