/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.TraversalStrategy;
import java.io.PrintWriter;
import java.util.Collection;

public class XMLPrinter
extends Printer {
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String DEFAULT_DTD_PREFIX = "http://depfind.sourceforge.net/dtd";
    private boolean atTopLevel = false;

    public XMLPrinter(PrintWriter out) {
        this(out, DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public XMLPrinter(TraversalStrategy strategy, PrintWriter out) {
        this(strategy, out, DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public XMLPrinter(PrintWriter out, String encoding, String dtdPrefix) {
        super(out);
        this.appendHeader(encoding, dtdPrefix);
    }

    public XMLPrinter(TraversalStrategy strategy, PrintWriter out, String encoding, String dtdPrefix) {
        super(strategy, out);
        this.appendHeader(encoding, dtdPrefix);
    }

    private void appendHeader(String encoding, String dtdPrefix) {
        this.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\" ?>").eol();
        this.eol();
        this.append("<!DOCTYPE dependencies SYSTEM \"").append(dtdPrefix).append("/dependencies.dtd\">").eol();
        this.eol();
    }

    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        if (this.atTopLevel) {
            super.traverseNodes(nodes);
        } else {
            this.atTopLevel = true;
            this.indent().append("<dependencies>").eol();
            this.raiseIndent();
            super.traverseNodes(nodes);
            this.lowerIndent();
            this.indent().append("</dependencies>").eol();
            this.atTopLevel = false;
        }
    }

    @Override
    protected void preprocessPackageNode(PackageNode node) {
        super.preprocessPackageNode(node);
        if (this.shouldShowPackageNode(node)) {
            this.indent().append("<package confirmed=\"").append(node.isConfirmed() ? "yes" : "no").append("\">").eol();
            this.raiseIndent();
            this.indent().printScopeNodeName(node).eol();
        }
    }

    @Override
    protected void postprocessPackageNode(PackageNode node) {
        if (this.shouldShowPackageNode(node)) {
            this.lowerIndent();
            this.indent().append("</package>").eol();
        }
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
        this.printInboundNode(node, "package");
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
        this.printOutboundNode(node, "package");
    }

    @Override
    protected void preprocessClassNode(ClassNode node) {
        super.preprocessClassNode(node);
        if (this.shouldShowClassNode(node)) {
            this.indent().append("<class confirmed=\"").append(node.isConfirmed() ? "yes" : "no").append("\">").eol();
            this.raiseIndent();
            this.indent().printScopeNodeName(node).eol();
        }
    }

    @Override
    protected void postprocessClassNode(ClassNode node) {
        if (this.shouldShowClassNode(node)) {
            this.lowerIndent();
            this.indent().append("</class>").eol();
        }
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
        this.printInboundNode(node, "class");
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
        this.printOutboundNode(node, "class");
    }

    @Override
    protected void preprocessFeatureNode(FeatureNode node) {
        super.preprocessFeatureNode(node);
        if (this.shouldShowFeatureNode(node)) {
            this.indent().append("<feature confirmed=\"").append(node.isConfirmed() ? "yes" : "no").append("\">").eol();
            this.raiseIndent();
            this.indent().printScopeNodeName(node).eol();
        }
    }

    @Override
    protected void postprocessFeatureNode(FeatureNode node) {
        if (this.shouldShowFeatureNode(node)) {
            this.lowerIndent();
            this.indent().append("</feature>").eol();
        }
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
        this.printInboundNode(node, "feature");
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        this.printOutboundNode(node, "feature");
    }

    public void printInboundNode(Node node, String type) {
        if (this.isShowInbounds()) {
            this.indent().append("<inbound type=\"").append(type).append("\" confirmed=\"").append(node.isConfirmed() ? "yes" : "no").append("\">").printDependencyNodeName(node).append("</inbound>").eol();
        }
    }

    public void printOutboundNode(Node node, String type) {
        if (this.isShowOutbounds()) {
            this.indent().append("<outbound type=\"").append(type).append("\" confirmed=\"").append(node.isConfirmed() ? "yes" : "no").append("\">").printDependencyNodeName(node).append("</outbound>").eol();
        }
    }

    @Override
    protected Printer printScopeNodeName(Node node, String name) {
        this.append("<name>");
        super.printScopeNodeName(node, name);
        this.append("</name>");
        return this;
    }
}

