/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.Class_info;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.NameAndType_info;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class EnclosingMethod_attribute
extends Attribute_info
implements com.jeantessier.classreader.EnclosingMethod_attribute {
    private int classIndex;
    private int methodIndex;

    public EnclosingMethod_attribute(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        super(constantPool, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        this.classIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Class index: " + this.classIndex + " (" + this.getClassInfo() + ")"));
        this.methodIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Method index: " + this.methodIndex + " (" + this.getMethod() + ")"));
    }

    @Override
    public int getClassIndex() {
        return this.classIndex;
    }

    @Override
    public Class_info getRawClassInfo() {
        return (Class_info)this.getConstantPool().get(this.getClassIndex());
    }

    @Override
    public String getClassInfo() {
        String result = "";
        if (this.getClassIndex() != 0) {
            result = this.getRawClassInfo().getName();
        }
        return result;
    }

    @Override
    public int getMethodIndex() {
        return this.methodIndex;
    }

    @Override
    public NameAndType_info getRawMethod() {
        return (NameAndType_info)this.getConstantPool().get(this.getMethodIndex());
    }

    @Override
    public String getMethod() {
        String result = "";
        if (this.getMethodIndex() != 0) {
            NameAndType_info rawMethod = this.getRawMethod();
            result = rawMethod.getName() + rawMethod.getType();
        }
        return result;
    }

    public String toString() {
        return "Enclosing method \"" + this.getRawMethod().getType() + " " + this.getClassInfo() + "." + this.getRawMethod().getName() + "\"";
    }

    @Override
    public String getAttributeName() {
        return AttributeType.ENCLOSING_METHOD.getAttributeName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitEnclosingMethod_attribute(this);
    }
}

