/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.ClassNameHelper;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.ConstantPoolEntry;
import com.jeantessier.classreader.impl.UTF8_info;
import java.io.DataInput;
import java.io.IOException;

public class Class_info
extends ConstantPoolEntry
implements com.jeantessier.classreader.Class_info {
    private int nameIndex;

    public Class_info(ConstantPool constantPool, DataInput in) throws IOException {
        super(constantPool);
        this.nameIndex = in.readUnsignedShort();
    }

    Class_info(ConstantPool constantPool, int nameIndex) {
        super(constantPool);
        this.nameIndex = nameIndex;
    }

    @Override
    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public UTF8_info getRawName() {
        return (UTF8_info)this.getConstantPool().get(this.getNameIndex());
    }

    @Override
    public String getName() {
        return ClassNameHelper.convertClassName(this.getRawName().getValue());
    }

    @Override
    public String getPackageName() {
        String result = "";
        String name = this.getName();
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            result = name.substring(0, pos);
        }
        return result;
    }

    @Override
    public String getSimpleName() {
        String name = this.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getRawName().hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object != null && this.getClass().equals(object.getClass())) {
            Class_info other = (Class_info)object;
            result = this.getRawName().equals(other.getRawName());
        }
        return result;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitClass_info(this);
    }
}

