/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollpanel;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.ScrollPanel;
import de.lessvoid.nifty.controls.ScrollPanelChangedEvent;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.controls.ScrollbarChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.Properties;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class ScrollPanelControl
extends AbstractController
implements ScrollPanel {
    private Nifty nifty;
    private Screen screen;
    private boolean verticalScrollbar;
    private boolean horizontalScrollbar;
    private Element childRootElement;
    private float stepSizeX;
    private float stepSizeY;
    private float pageSizeX;
    private float pageSizeY;
    private ScrollPanel.AutoScroll autoScroll = ScrollPanel.AutoScroll.OFF;
    private EventTopicSubscriber<ScrollbarChangedEvent> horizontalScrollbarSubscriber;
    private EventTopicSubscriber<ScrollbarChangedEvent> verticalScrollbarSubscriber;

    public void bind(Nifty niftyParam, Screen screenParam, Element elementParam, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(elementParam);
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.verticalScrollbar = new Boolean(parameter.getProperty("vertical", "true"));
        this.horizontalScrollbar = new Boolean(parameter.getProperty("horizontal", "true"));
        this.childRootElement = this.getElement().findElementByName(controlDefinitionAttributes.get("childRootId"));
        this.stepSizeX = new Float(parameter.getProperty("stepSizeX", "1.0")).floatValue();
        this.stepSizeY = new Float(parameter.getProperty("stepSizeY", "1.0")).floatValue();
        this.pageSizeX = new Float(parameter.getProperty("pageSizeX", "1.0")).floatValue();
        this.pageSizeY = new Float(parameter.getProperty("pageSizeY", "1.0")).floatValue();
        this.autoScroll = ScrollPanel.AutoScroll.parse(parameter.getProperty("autoScroll", "off"));
        this.horizontalScrollbarSubscriber = new HorizontalEventTopicSubscriber(this);
        this.verticalScrollbarSubscriber = new VerticalEventTopicSubscriber(this);
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        this.initializeScrollPanel();
        this.initializeScrollbars();
        this.subscribeHorizontalScrollbar();
        this.subscribeVerticalScrollbar();
        super.init(parameter, controlDefinitionAttributes);
    }

    public void onStartScreen() {
    }

    public void layoutCallback() {
        if (this.childRootElement != null) {
            List elements = this.childRootElement.getElements();
            if (elements.isEmpty()) {
                return;
            }
            Element scrollElement = (Element)elements.get(0);
            if (scrollElement != null) {
                Scrollbar verticalS;
                Scrollbar horizontalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-horizontal-scrollbar", Scrollbar.class);
                if (horizontalS != null) {
                    horizontalS.setWorldMax(scrollElement.getWidth());
                    horizontalS.setWorldPageSize(horizontalS.getWidth());
                    this.updateWorldH();
                }
                if ((verticalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class)) != null) {
                    verticalS.setWorldMax(scrollElement.getHeight());
                    verticalS.setWorldPageSize(verticalS.getHeight());
                    this.updateWorldV();
                }
            }
        }
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    @Override
    public void setHorizontalPos(float xPos) {
        Scrollbar horizontalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-horizontal-scrollbar", Scrollbar.class);
        if (horizontalS != null && this.verticalScrollbar) {
            horizontalS.setValue(xPos);
        }
    }

    @Override
    public float getHorizontalPos() {
        Scrollbar horizontalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-horizontal-scrollbar", Scrollbar.class);
        if (horizontalS != null && this.verticalScrollbar) {
            return horizontalS.getValue();
        }
        return 0.0f;
    }

    @Override
    public void setVerticalPos(float yPos) {
        Scrollbar verticalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
        if (verticalS != null && this.verticalScrollbar) {
            verticalS.setValue(yPos);
        }
    }

    @Override
    public float getVerticalPos() {
        Scrollbar verticalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
        if (verticalS != null && this.verticalScrollbar) {
            return verticalS.getValue();
        }
        return 0.0f;
    }

    @Override
    public void showElementVertical(int elemCount) {
        this.showElementVertical(elemCount, ScrollPanel.VerticalAlign.center);
    }

    @Override
    public void setUp(float stepSizeX, float stepSizeY, float pageSizeX, float pageSizeY, ScrollPanel.AutoScroll auto) {
        this.stepSizeX = stepSizeX;
        this.stepSizeY = stepSizeY;
        this.pageSizeX = pageSizeX;
        this.pageSizeY = pageSizeY;
        this.autoScroll = auto;
        this.initializeScrollbars();
    }

    @Override
    public void setAutoScroll(ScrollPanel.AutoScroll auto) {
        this.autoScroll = auto;
        this.updateWorldH();
        this.updateWorldV();
    }

    @Override
    public ScrollPanel.AutoScroll getAutoScroll() {
        return this.autoScroll;
    }

    @Override
    public void setStepSizeX(float stepSizeX) {
        this.stepSizeX = stepSizeX;
        Scrollbar horizontalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-horizontal-scrollbar", Scrollbar.class);
        if (horizontalS != null) {
            horizontalS.setButtonStepSize(stepSizeX);
        }
    }

    @Override
    public void setStepSizeY(float stepSizeY) {
        this.stepSizeY = stepSizeY;
        Scrollbar verticalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
        if (verticalS != null) {
            verticalS.setButtonStepSize(stepSizeY);
        }
    }

    @Override
    public void setPageSizeX(float pageSizeX) {
        this.pageSizeX = pageSizeX;
        Scrollbar horizontalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-horizontal-scrollbar", Scrollbar.class);
        if (horizontalS != null) {
            horizontalS.setPageStepSize(pageSizeX);
        }
    }

    @Override
    public void setPageSizeY(float pageSizeY) {
        this.pageSizeY = pageSizeY;
        Scrollbar verticalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
        if (verticalS != null) {
            verticalS.setPageStepSize(pageSizeY);
        }
    }

    public void mouseWheel(Element e, NiftyMouseInputEvent inputEvent) {
        int mouseWheel = inputEvent.getMouseWheel();
        Scrollbar verticalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
        if (verticalS != null) {
            float currentValue = verticalS.getValue();
            if (mouseWheel < 0) {
                verticalS.setValue(currentValue - verticalS.getButtonStepSize() * (float)mouseWheel);
            } else if (mouseWheel > 0) {
                verticalS.setValue(currentValue - verticalS.getButtonStepSize() * (float)mouseWheel);
            }
        }
    }

    private void subscribeVerticalScrollbar() {
        Element scrollbar = this.getElement().findElementByName("#nifty-internal-vertical-scrollbar");
        if (scrollbar != null) {
            this.nifty.subscribe(this.screen, scrollbar.getId(), ScrollbarChangedEvent.class, this.verticalScrollbarSubscriber);
        }
    }

    private void subscribeHorizontalScrollbar() {
        Element scrollbar = this.getElement().findElementByName("#nifty-internal-horizontal-scrollbar");
        if (scrollbar != null) {
            this.nifty.subscribe(this.screen, scrollbar.getId(), ScrollbarChangedEvent.class, this.horizontalScrollbarSubscriber);
        }
    }

    private void initializeScrollPanel() {
        Element horizontal;
        Element vertical;
        if (!this.verticalScrollbar && (vertical = this.getElement().findElementByName("#nifty-internal-vertical-scrollbar")) != null) {
            this.nifty.removeElement(this.screen, vertical);
        }
        if (!this.horizontalScrollbar && (horizontal = this.getElement().findElementByName("#nifty-internal-horizonal-panel")) != null) {
            this.nifty.removeElement(this.screen, horizontal);
        }
        this.nifty.executeEndOfFrameElementActions();
        this.screen.layoutLayers();
    }

    private void initializeScrollbars() {
        if (this.childRootElement != null) {
            List elements = this.childRootElement.getElements();
            if (elements.isEmpty()) {
                return;
            }
            Element scrollElement = (Element)elements.get(0);
            if (scrollElement != null) {
                Scrollbar verticalS;
                Scrollbar horizontalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-horizontal-scrollbar", Scrollbar.class);
                if (horizontalS != null) {
                    horizontalS.setWorldMax(scrollElement.getWidth());
                    this.updateWorldH();
                    horizontalS.setWorldPageSize(horizontalS.getWidth());
                    horizontalS.setValue(0.0f);
                    horizontalS.setButtonStepSize(this.stepSizeX);
                    horizontalS.setPageStepSize(this.pageSizeX);
                }
                if ((verticalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class)) != null) {
                    verticalS.setWorldMax(scrollElement.getHeight());
                    this.updateWorldV();
                    verticalS.setWorldPageSize(verticalS.getHeight());
                    verticalS.setValue(0.0f);
                    verticalS.setButtonStepSize(this.stepSizeY);
                    verticalS.setPageStepSize(this.pageSizeY);
                }
                scrollElement.setConstraintX(new SizeValue("0px"));
                scrollElement.setConstraintY(new SizeValue("0px"));
            }
            scrollElement.layoutElements();
        }
    }

    private void updateWorldH() {
        Scrollbar horizontalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-horizontal-scrollbar", Scrollbar.class);
        if (horizontalS != null) {
            if (this.autoScroll == ScrollPanel.AutoScroll.RIGHT || this.autoScroll == ScrollPanel.AutoScroll.BOTTOM_RIGHT || this.autoScroll == ScrollPanel.AutoScroll.TOP_RIGHT) {
                horizontalS.setValue(horizontalS.getWorldMax());
            } else if (this.autoScroll == ScrollPanel.AutoScroll.LEFT || this.autoScroll == ScrollPanel.AutoScroll.BOTTOM_LEFT || this.autoScroll == ScrollPanel.AutoScroll.TOP_LEFT) {
                horizontalS.setValue(0.0f);
            }
        }
    }

    private void updateWorldV() {
        Scrollbar verticalS = (Scrollbar)this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
        if (verticalS != null) {
            if (this.autoScroll == ScrollPanel.AutoScroll.BOTTOM || this.autoScroll == ScrollPanel.AutoScroll.BOTTOM_LEFT || this.autoScroll == ScrollPanel.AutoScroll.BOTTOM_RIGHT) {
                verticalS.setValue(verticalS.getWorldMax());
            } else if (this.autoScroll == ScrollPanel.AutoScroll.TOP || this.autoScroll == ScrollPanel.AutoScroll.TOP_LEFT || this.autoScroll == ScrollPanel.AutoScroll.TOP_RIGHT) {
                verticalS.setValue(0.0f);
            }
        }
    }

    private void showElementVertical(int elemCount, ScrollPanel.VerticalAlign valign) {
        float newPos;
        switch (valign) {
            case top: {
                newPos = this.stepSizeY * (float)elemCount;
                break;
            }
            case center: {
                newPos = this.stepSizeY * (float)elemCount - (float)(this.getElement().getHeight() / 2);
                break;
            }
            case bottom: {
                newPos = this.stepSizeY * (float)elemCount - (float)this.getElement().getHeight();
                break;
            }
            default: {
                newPos = 0.0f;
            }
        }
        this.setVerticalPos(newPos);
    }

    private class HorizontalEventTopicSubscriber
    implements EventTopicSubscriber<ScrollbarChangedEvent> {
        private ScrollPanel scrollPanel;

        public HorizontalEventTopicSubscriber(ScrollPanel scrollPanel) {
            this.scrollPanel = scrollPanel;
        }

        public void onEvent(String id, ScrollbarChangedEvent event) {
            if (ScrollPanelControl.this.childRootElement == null) {
                return;
            }
            if (ScrollPanelControl.this.childRootElement.getElements().isEmpty()) {
                return;
            }
            Element scrollElement = (Element)ScrollPanelControl.this.childRootElement.getElements().get(0);
            if (scrollElement != null) {
                scrollElement.setConstraintX(new SizeValue(-((int)event.getValue()) + "px"));
                ScrollPanelControl.this.updateWorldH();
                scrollElement.getParent().layoutElements();
                float yPos = 0.0f;
                Scrollbar verticalS = (Scrollbar)ScrollPanelControl.this.getElement().findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
                if (verticalS != null && ScrollPanelControl.this.verticalScrollbar) {
                    yPos = verticalS.getValue();
                }
                ScrollPanelControl.this.nifty.publishEvent(ScrollPanelControl.this.getElement().getId(), (NiftyEvent)new ScrollPanelChangedEvent(this.scrollPanel, event.getValue(), yPos));
            }
        }
    }

    private class VerticalEventTopicSubscriber
    implements EventTopicSubscriber<ScrollbarChangedEvent> {
        private ScrollPanel scrollPanel;

        public VerticalEventTopicSubscriber(ScrollPanel scrollPanel) {
            this.scrollPanel = scrollPanel;
        }

        public void onEvent(String id, ScrollbarChangedEvent event) {
            if (ScrollPanelControl.this.childRootElement == null) {
                return;
            }
            if (ScrollPanelControl.this.childRootElement.getElements().isEmpty()) {
                return;
            }
            Element scrollElement = (Element)ScrollPanelControl.this.childRootElement.getElements().get(0);
            if (scrollElement != null) {
                scrollElement.setConstraintY(new SizeValue(-((int)event.getValue()) + "px"));
                ScrollPanelControl.this.updateWorldV();
                scrollElement.getParent().layoutElements();
                float xPos = 0.0f;
                Scrollbar horizontalS = (Scrollbar)ScrollPanelControl.this.getElement().findNiftyControl("#nifty-internal-horizontal-scrollbar", Scrollbar.class);
                if (horizontalS != null && ScrollPanelControl.this.horizontalScrollbar) {
                    xPos = horizontalS.getValue();
                }
                ScrollPanelControl.this.nifty.publishEvent(ScrollPanelControl.this.getElement().getId(), (NiftyEvent)new ScrollPanelChangedEvent(this.scrollPanel, xPos, event.getValue()));
            }
        }
    }
}

