/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dropdown.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.dropdown.CreateDropDownControlItem;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import java.util.ArrayList;
import java.util.List;

public class DropDownModel {
    private List<String> items = new ArrayList<String>();
    private int selectedItemIdx = -1;

    public void addItem(String description) {
        this.items.add(description);
    }

    public void initialize(Nifty nifty, Screen screen, Element parent, String style) {
        int count = 0;
        for (String item : this.items) {
            String id = parent.getId() + "_" + count++;
            CreateDropDownControlItem dropDownItem = new CreateDropDownControlItem(id, item);
            dropDownItem.create(nifty, screen, parent, style);
        }
    }

    public void setSelectedItemIdx(int idx) {
        this.selectedItemIdx = idx;
    }

    public void setSelectedItem(String text) {
        this.selectedItemIdx = this.items.indexOf(text);
    }

    public String getSelectedItem() {
        return this.items.get(this.selectedItemIdx);
    }

    public int getSelectedItemIdx() {
        return this.selectedItemIdx;
    }

    public void clear() {
        this.items.clear();
    }

    public int gotoNextItem() {
        this.selectedItemIdx = this.selectedItemIdx < this.items.size() - 1 ? ++this.selectedItemIdx : 0;
        return this.selectedItemIdx;
    }

    public int gotoPrevItem() {
        this.selectedItemIdx = this.selectedItemIdx > 0 ? --this.selectedItemIdx : this.items.size() - 1;
        return this.selectedItemIdx;
    }
}

