/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dropdown.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.NiftyObservable;
import de.lessvoid.nifty.controls.dropdown.controller.DropDownControlItem;
import de.lessvoid.nifty.controls.dropdown.controller.DropDownControlNotify;
import de.lessvoid.nifty.controls.dropdown.controller.DropDownModel;
import de.lessvoid.nifty.controls.dropdown.controller.DropDownPopup;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;

public class DropDownControl
implements Controller {
    private Nifty nifty;
    private Element element;
    private boolean alreadyOpen = false;
    private DropDownModel dropDownModel = new DropDownModel();
    private FocusHandler focusHandler;
    private Screen screen;
    private NiftyObservable observable = new NiftyObservable();

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, ControllerEventListener newListener, Attributes controlDefinitionAttributesParam) {
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.element = newElement;
    }

    public void onStartScreen() {
        this.focusHandler = this.screen.getFocusHandler();
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.NextInputElement) {
            this.focusHandler.getNext(this.element).setFocus();
            return true;
        }
        if (inputEvent == NiftyInputEvent.PrevInputElement) {
            this.focusHandler.getPrev(this.element).setFocus();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Activate) {
            this.dropDownClicked();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorUp) {
            this.setSelectedItemIdx(this.dropDownModel.gotoPrevItem());
            this.notifyObservers();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorDown) {
            this.setSelectedItemIdx(this.dropDownModel.gotoNextItem());
            this.notifyObservers();
            return true;
        }
        return false;
    }

    public void dropDownClicked() {
        if (this.alreadyOpen) {
            return;
        }
        this.alreadyOpen = true;
        String parentStyle = this.element.getElementType().getAttributes().get("style");
        Element popupLayer = this.nifty.createPopupWithStyle("dropDownBoxSelectPopup", parentStyle);
        Element popup = popupLayer.findElementByName("dropDownList");
        popup.setConstraintX(new SizeValue(this.element.getX() + "px"));
        popup.setConstraintY(new SizeValue(this.element.getY() + this.element.getHeight() + "px"));
        popup.setConstraintWidth(new SizeValue(this.element.getWidth() + "px"));
        for (Element e : popup.getElements()) {
            this.nifty.removeElement(this.nifty.getCurrentScreen(), e);
        }
        this.dropDownModel.initialize(this.nifty, this.nifty.getCurrentScreen(), popup, parentStyle);
        this.nifty.addControlsWithoutStartScreen();
        int maxHeight = this.getMaxHeight(popup);
        popup.layoutElements();
        popup.setConstraintHeight(new SizeValue(maxHeight + "px"));
        ((DropDownPopup)popupLayer.getControl(DropDownPopup.class)).setDropDownElement(this.element);
        Element selectedElement = this.convertSelectedItemToElement(popup, this.dropDownModel.getSelectedItemIdx());
        this.nifty.showPopup(this.nifty.getCurrentScreen(), "dropDownBoxSelectPopup", selectedElement);
    }

    int getMaxHeight(Element popup) {
        int maxHeight = 0;
        for (Element child : popup.getElements()) {
            ((DropDownControlItem)child.getControl(DropDownControlItem.class)).setDropDownControl(this.element);
            maxHeight += child.getHeight();
        }
        return maxHeight;
    }

    private Element convertSelectedItemToElement(Element popup, int selectedItemIdx) {
        if (selectedItemIdx == -1) {
            return null;
        }
        for (int idx = 0; idx < popup.getElements().size(); ++idx) {
            if (idx != selectedItemIdx) continue;
            return (Element)popup.getElements().get(idx);
        }
        return null;
    }

    public void reset() {
        this.alreadyOpen = false;
    }

    public void addItem(String item) {
        this.dropDownModel.addItem(item);
    }

    public void setSelectedItemIdx(int idx) {
        this.dropDownModel.setSelectedItemIdx(idx);
        this.changeSelectedItem(this.dropDownModel.getSelectedItem());
    }

    public void setSelectedItem(String text) {
        this.dropDownModel.setSelectedItem(text);
        this.changeSelectedItem(this.dropDownModel.getSelectedItem());
    }

    public String getSelectedItem() {
        return this.dropDownModel.getSelectedItem();
    }

    public int getSelectedItemIdx() {
        return this.dropDownModel.getSelectedItemIdx();
    }

    public void clear() {
        this.dropDownModel.clear();
    }

    public void addNotify(final DropDownControlNotify notity) {
        this.observable.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                notity.dropDownSelectionChanged(DropDownControl.this);
            }
        });
    }

    public void removeAllNotifies() {
        this.observable.deleteObservers();
    }

    private void changeSelectedItem(String selectedItem) {
        TextRenderer text = (TextRenderer)this.element.findElementByName("text").getRenderer(TextRenderer.class);
        text.setText(selectedItem);
    }

    public void notifyObservers() {
        this.observable.setChanged();
        this.observable.notifyObservers();
    }

    public Element getElement() {
        return this.element;
    }
}

