/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.helloworld;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;

public class TextTyping
implements EffectImpl {
    private int effectLength;
    private float startSize;
    private float endSize;
    private float stepTime;
    private String originalText;
    private TextRenderer textRenderer;

    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.textRenderer = (TextRenderer)element.getRenderer(TextRenderer.class);
        this.originalText = this.textRenderer.getOriginalText();
        this.effectLength = Integer.valueOf(parameter.getProperty("length", "1000"));
        this.startSize = Float.valueOf(parameter.getProperty("startSize", "5.0")).floatValue();
        this.endSize = Float.valueOf(parameter.getProperty("endSize", "1.0")).floatValue();
        this.stepTime = this.effectLength / this.originalText.length();
        this.updateText("");
    }

    public void execute(Element element, float effectTime, Falloff falloff, NiftyRenderEngine r) {
        int currentIndex = (int)((float)this.originalText.length() * effectTime);
        String currentText = this.originalText.substring(0, currentIndex);
        if (currentIndex < this.originalText.length()) {
            String nextChar = this.originalText.substring(currentIndex, currentIndex + 1);
            int textWidth = this.textRenderer.getFont().getWidth(currentText);
            float currentTime = effectTime * (float)this.effectLength;
            float normalizedStepTime = currentTime % this.stepTime / this.stepTime;
            float charSize = this.startSize + normalizedStepTime * (this.endSize - this.startSize);
            r.saveState(null);
            r.setFont(this.textRenderer.getFont());
            r.setRenderTextSize(charSize);
            r.renderText(nextChar, element.getX() + textWidth, element.getY(), -1, -1, Color.WHITE);
            r.restoreState();
        }
        this.updateText(currentText);
    }

    public void deactivate() {
    }

    private void updateText(String currentText) {
        this.textRenderer.setText(currentText);
    }
}

