/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.CapsListener;
import com.fluendo.jst.Event;
import com.fluendo.jst.Object;
import com.fluendo.jst.Query;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class Pad
extends Object
implements Runnable {
    public static final int UNKNOWN = 0;
    public static final int SRC = 1;
    public static final int SINK = 2;
    public static final int OK = 0;
    public static final int NOT_LINKED = -1;
    public static final int WRONG_STATE = -2;
    public static final int UNEXPECTED = -3;
    public static final int NOT_NEGOTIATED = -4;
    public static final int ERROR = -5;
    public static final int NOT_SUPPORTED = -6;
    public static final int MODE_NONE = 0;
    public static final int MODE_PUSH = 1;
    public static final int MODE_PULL = 2;
    protected Pad peer;
    protected int direction = 0;
    protected boolean flushing;
    protected java.lang.Object streamLock = new java.lang.Object();
    int mode;
    private Vector capsListeners = new Vector();
    protected Caps caps;
    private static final int T_STOP = 0;
    private static final int T_PAUSE = 1;
    private static final int T_START = 2;
    private Thread thread;
    private int taskState;

    public static final boolean isFlowFatal(int ret) {
        return ret <= -3;
    }

    public static final boolean isFlowSuccess(int ret) {
        return ret >= 0;
    }

    public static final String getFlowName(int ret) {
        switch (ret) {
            case 0: {
                return "ok";
            }
            case -1: {
                return "not-linked";
            }
            case -2: {
                return "wrong-state";
            }
            case -3: {
                return "unexpected";
            }
            case -4: {
                return "not-negotiated";
            }
            case -5: {
                return "error";
            }
            case -6: {
                return "not-supported";
            }
        }
        return "unknown";
    }

    public Pad(int direction) {
        this(direction, null);
    }

    public Pad(int direction, String name) {
        super(name);
        this.direction = direction;
    }

    public String toString() {
        String parentName = this.parent != null ? this.parent.getName() : "";
        String thisName = this.getName();
        if (thisName == null) {
            thisName = "";
        }
        return "Pad: " + parentName + ":" + thisName;
    }

    public synchronized void addCapsListener(CapsListener listener) {
        this.capsListeners.addElement(listener);
    }

    public synchronized void removeCapsListener(CapsListener listener) {
        this.capsListeners.removeElement(listener);
    }

    private synchronized void doCapsListeners(Caps caps) {
        Enumeration e = this.capsListeners.elements();
        while (e.hasMoreElements()) {
            CapsListener listener = (CapsListener)e.nextElement();
            listener.capsChanged(caps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean link(Pad newPeer) {
        if (this.peer != null) {
            return false;
        }
        if (this.direction != 1) {
            return false;
        }
        Pad pad = newPeer;
        synchronized (pad) {
            if (newPeer.direction != 2) {
                return false;
            }
            if (newPeer.peer != null) {
                return false;
            }
            this.peer = newPeer;
            this.peer.peer = this;
        }
        return true;
    }

    public synchronized void unlink() {
        if (this.peer == null) {
            return;
        }
        if (this.direction == 1) {
            this.peer.unlink();
        }
        this.peer = null;
    }

    public synchronized Pad getPeer() {
        return this.peer;
    }

    protected boolean eventFunc(Event event) {
        switch (event.getType()) {
            default: 
        }
        boolean result = false;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sendEvent(Event event) {
        boolean result;
        Debug.debug(this + " got event " + event);
        switch (event.getType()) {
            case 1: {
                this.setFlushing(true);
                result = this.eventFunc(event);
                break;
            }
            case 2: {
                java.lang.Object object = this.streamLock;
                synchronized (object) {
                    this.setFlushing(false);
                    result = this.eventFunc(event);
                    break;
                }
            }
            case 3: 
            case 4: {
                java.lang.Object object = this.streamLock;
                synchronized (object) {
                    result = this.eventFunc(event);
                    break;
                }
            }
            case 5: {
                result = this.eventFunc(event);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean query(Query query) {
        return false;
    }

    public synchronized Caps getCaps() {
        return this.caps;
    }

    protected boolean setCapsFunc(Caps caps) {
        return true;
    }

    public boolean setCaps(Caps caps) {
        boolean res = true;
        if (caps != null) {
            res = this.setCapsFunc(caps);
        }
        if (res) {
            this.caps = caps;
            if (caps != null) {
                this.doCapsListeners(caps);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int chain(Buffer buffer) {
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            Pad pad = this;
            synchronized (pad) {
                if (this.flushing) {
                    return -2;
                }
                if (buffer.caps != null && buffer.caps != this.caps && !this.setCaps(buffer.caps)) {
                    buffer.free();
                    return -4;
                }
            }
            int res = this.chainFunc(buffer);
            return res;
        }
    }

    protected int chainFunc(Buffer buffer) {
        return -5;
    }

    public final int push(Buffer buffer) {
        if (this.peer == null) {
            return -1;
        }
        return this.peer.chain(buffer);
    }

    public final boolean pushEvent(Event event) {
        if (this.peer == null) {
            return false;
        }
        return this.peer.sendEvent(event);
    }

    public synchronized void setFlushing(boolean flush) {
        this.flushing = flush;
    }

    public synchronized boolean isFlushing() {
        return this.flushing;
    }

    protected boolean activateFunc(int mode) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean activate(int newMode) {
        boolean res;
        Debug.debug(this + " activate mode = " + (newMode == 0 ? "none" : "push"));
        if (this.mode == newMode) {
            return true;
        }
        if (newMode == 0) {
            this.setFlushing(true);
        }
        if (!(res = this.activateFunc(newMode))) {
            return false;
        }
        if (newMode != 0) {
            this.setFlushing(false);
        } else {
            java.lang.Object object = this.streamLock;
            synchronized (object) {
                this.setCaps(null);
            }
        }
        this.mode = newMode;
        return res;
    }

    protected void taskFunc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            while (this.taskState != 0) {
                while (this.taskState == 1) {
                    Debug.debug(this.parent.getName() + ":" + this.getName() + " paused, waiting...");
                    try {
                        this.streamLock.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                if (this.taskState == 0) break;
                try {
                    this.taskFunc();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTask(String name) {
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            this.taskState = 2;
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, name);
                this.thread.start();
            }
            this.streamLock.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseTask() {
        this.taskState = 1;
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            this.taskState = 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTask() {
        Thread t;
        this.taskState = 0;
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            this.taskState = 0;
            this.streamLock.notifyAll();
            t = this.thread;
            this.thread = null;
        }
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }
}

