/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.converters.model.strip;

import java.util.Arrays;
import jme3tools.converters.model.strip.FaceInfoVec;
import jme3tools.converters.model.strip.IntVec;
import jme3tools.converters.model.strip.PrimitiveGroup;
import jme3tools.converters.model.strip.StripInfoVec;
import jme3tools.converters.model.strip.Stripifier;

public class TriStrip {
    public static final int CACHESIZE_GEFORCE1_2 = 16;
    public static final int CACHESIZE_GEFORCE3 = 24;
    int cacheSize = 16;
    boolean bStitchStrips = true;
    int minStripSize = 0;
    boolean bListsOnly = false;

    public void setListsOnly(boolean _bListsOnly) {
        this.bListsOnly = _bListsOnly;
    }

    public void setCacheSize(int _cacheSize) {
        this.cacheSize = _cacheSize;
    }

    public void setStitchStrips(boolean _bStitchStrips) {
        this.bStitchStrips = _bStitchStrips;
    }

    public void setMinStripSize(int _minStripSize) {
        this.minStripSize = _minStripSize;
    }

    public PrimitiveGroup[] generateStrips(int[] in_indices) {
        PrimitiveGroup[] primGroups;
        block15: {
            int i;
            int numSeparateStrips;
            IntVec stripIndices;
            Stripifier stripifier;
            FaceInfoVec tempFaces;
            StripInfoVec tempStrips;
            int numGroups;
            block14: {
                int i2;
                numGroups = 0;
                IntVec tempIndices = new IntVec();
                int maxIndex = 0;
                for (int i3 = 0; i3 < in_indices.length; ++i3) {
                    tempIndices.add(in_indices[i3]);
                    if (in_indices[i3] <= maxIndex) continue;
                    maxIndex = in_indices[i3];
                }
                tempStrips = new StripInfoVec();
                tempFaces = new FaceInfoVec();
                stripifier = new Stripifier();
                stripifier.stripify(tempIndices, this.cacheSize, this.minStripSize, maxIndex, tempStrips, tempFaces);
                stripIndices = new IntVec();
                numSeparateStrips = 0;
                if (!this.bListsOnly) break block14;
                numGroups = 1;
                primGroups = new PrimitiveGroup[numGroups];
                primGroups[0] = new PrimitiveGroup();
                PrimitiveGroup[] primGroupArray = primGroups;
                int numIndices = 0;
                for (int i4 = 0; i4 < tempStrips.size(); ++i4) {
                    numIndices += tempStrips.at((int)i4).m_faces.size() * 3;
                }
                primGroupArray[0].type = 0;
                primGroupArray[0].indices = new int[numIndices += tempFaces.size() * 3];
                primGroupArray[0].numIndices = numIndices;
                int indexCtr = 0;
                for (i2 = 0; i2 < tempStrips.size(); ++i2) {
                    for (int j = 0; j < tempStrips.at((int)i2).m_faces.size(); ++j) {
                        if (!Stripifier.isDegenerate(tempStrips.at((int)i2).m_faces.at(j))) {
                            primGroupArray[0].indices[indexCtr++] = tempStrips.at((int)i2).m_faces.at((int)j).m_v0;
                            primGroupArray[0].indices[indexCtr++] = tempStrips.at((int)i2).m_faces.at((int)j).m_v1;
                            primGroupArray[0].indices[indexCtr++] = tempStrips.at((int)i2).m_faces.at((int)j).m_v2;
                            continue;
                        }
                        primGroupArray[0].numIndices -= 3;
                    }
                }
                for (i2 = 0; i2 < tempFaces.size(); ++i2) {
                    primGroupArray[0].indices[indexCtr++] = tempFaces.at((int)i2).m_v0;
                    primGroupArray[0].indices[indexCtr++] = tempFaces.at((int)i2).m_v1;
                    primGroupArray[0].indices[indexCtr++] = tempFaces.at((int)i2).m_v2;
                }
                break block15;
            }
            numGroups = numSeparateStrips = stripifier.createStrips(tempStrips, stripIndices, this.bStitchStrips);
            if (tempFaces.size() != 0) {
                ++numGroups;
            }
            primGroups = new PrimitiveGroup[numGroups];
            for (int i5 = 0; i5 < primGroups.length; ++i5) {
                primGroups[i5] = new PrimitiveGroup();
            }
            PrimitiveGroup[] primGroupArray = primGroups;
            int startingLoc = 0;
            for (int stripCtr = 0; stripCtr < numSeparateStrips; ++stripCtr) {
                int stripLength = 0;
                if (!this.bStitchStrips) {
                    for (i = startingLoc; i < stripIndices.size() && stripIndices.get(i) != -1; ++i) {
                    }
                    stripLength = i - startingLoc;
                } else {
                    stripLength = stripIndices.size();
                }
                primGroupArray[stripCtr].type = 1;
                primGroupArray[stripCtr].indices = new int[stripLength];
                primGroupArray[stripCtr].numIndices = stripLength;
                int indexCtr = 0;
                for (int i6 = startingLoc; i6 < stripLength + startingLoc; ++i6) {
                    primGroupArray[stripCtr].indices[indexCtr++] = stripIndices.get(i6);
                }
                startingLoc += stripLength + 1;
            }
            if (tempFaces.size() == 0) break block15;
            int faceGroupLoc = numGroups - 1;
            primGroupArray[faceGroupLoc].type = 0;
            primGroupArray[faceGroupLoc].indices = new int[tempFaces.size() * 3];
            primGroupArray[faceGroupLoc].numIndices = tempFaces.size() * 3;
            int indexCtr = 0;
            for (i = 0; i < tempFaces.size(); ++i) {
                primGroupArray[faceGroupLoc].indices[indexCtr++] = tempFaces.at((int)i).m_v0;
                primGroupArray[faceGroupLoc].indices[indexCtr++] = tempFaces.at((int)i).m_v1;
                primGroupArray[faceGroupLoc].indices[indexCtr++] = tempFaces.at((int)i).m_v2;
            }
        }
        return primGroups;
    }

    public static int[] remapIndices(int[] indices, int numVerts) {
        int[] indexCache = new int[numVerts];
        Arrays.fill(indexCache, -1);
        int numIndices = indices.length;
        int[] remappedIndices = new int[numIndices];
        int indexCtr = 0;
        for (int j = 0; j < numIndices; ++j) {
            int cachedIndex = indexCache[indices[j]];
            if (cachedIndex == -1) {
                remappedIndices[j] = indexCtr;
                indexCache[indices[j]] = indexCtr++;
                continue;
            }
            remappedIndices[j] = cachedIndex;
        }
        return remappedIndices;
    }

    public static void remapArrays(float[] vertexBuffer, int vertexSize, int[] indices) {
        int[] remapped = TriStrip.remapIndices(indices, vertexBuffer.length / vertexSize);
        float[] bufferCopy = (float[])vertexBuffer.clone();
        for (int i = 0; i < remapped.length; ++i) {
            int from = indices[i] * vertexSize;
            int to = remapped[i] * vertexSize;
            for (int j = 0; j < vertexSize; ++j) {
                vertexBuffer[to + j] = bufferCopy[from + j];
            }
        }
        System.arraycopy(remapped, 0, indices, 0, indices.length);
    }
}

