/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.video.plugins.jheora;

import com.jcraft.jogg.Packet;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jme3.audio.AudioStream;
import com.jme3.video.Clock;
import com.jme3.video.RingBuffer;
import com.jme3.video.SystemClock;
import java.io.InputStream;

@Deprecated
public class ADecoder
extends InputStream
implements Clock {
    private int packetIndex = 0;
    private final DspState dsp;
    private Block block;
    private Info info;
    private Comment comment;
    private float[][][] pcmAll = new float[1][][];
    private int[] index;
    private AudioStream stream;
    private RingBuffer ringBuffer = new RingBuffer(384000);
    private int UNCOMP_BUFSIZE = 4096;
    private byte[] uncompBuf = new byte[this.UNCOMP_BUFSIZE];
    private long lastPts = 0L;
    private long lastWritten = 0L;
    private long lastRead = 0L;
    private long lastPtsRead = 0L;
    private long lastPtsWrite = 0L;
    private long timeDiffSum = 0L;
    private int timesDesynced = 0;
    private Clock masterClock;
    private static final long NOSYNC_THRESH = 3000000000L;
    private static final long AUDIO_DIFF_THRESH = 500000000L;
    private static final int NUM_DIFFS_FOR_SYNC = 5;
    private static final double PRODUCT_FOR_PREV = 0.6;
    private static final double PRODUCT_FOR_PREV_INV = 0.4;
    private int needToSkip = 0;

    public ADecoder() {
        this.info = new Info();
        this.info.init();
        this.comment = new Comment();
        this.comment.init();
        this.dsp = new DspState();
        this.block = new Block(this.dsp);
    }

    public void setMasterClock(Clock masterClock) {
        this.masterClock = masterClock;
    }

    public AudioStream getAudioStream() {
        return this.stream;
    }

    public long getTime() {
        long bytesRead = this.ringBuffer.getTotalRead();
        if (bytesRead == 0L) {
            return 0L;
        }
        long diff = bytesRead;
        long diffNs = diff * 1000000000L / (long)(2 * this.info.channels * this.info.rate);
        long timeSinceLastRead = System.nanoTime() - this.lastPtsRead;
        return diffNs + timeSinceLastRead;
    }

    public double getTimeSeconds() {
        return (double)this.getTime() / 1.0E9;
    }

    public int read() {
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read < 0) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    private void sync() {
        if (this.needToSkip > 0) {
            int skipped = this.ringBuffer.skip(this.needToSkip);
            System.out.println("Skipped: " + skipped);
            this.needToSkip -= skipped;
        }
        long masterTime = this.masterClock.getTime();
        long audioTime = this.getTime();
        long diff = audioTime - masterTime;
        if (diff < 3000000000L) {
            this.timeDiffSum = diff + (long)((double)this.timeDiffSum * 0.6);
            if (this.timesDesynced < 5) {
                ++this.timesDesynced;
            } else {
                long avgDiff = (long)((double)this.timeDiffSum * 0.4);
                if (Math.abs(avgDiff) >= 500000000L && diff < 0L) {
                    int toSkip = (int)(-diff * 2L * (long)this.info.channels * (long)this.info.rate / 1000000000L);
                    int skipped = this.ringBuffer.skip(toSkip);
                    System.out.println("Skipped: " + skipped);
                    if (skipped < toSkip) {
                        this.needToSkip = toSkip - skipped;
                    }
                    this.timeDiffSum = 0L;
                    this.timesDesynced = 0;
                }
            }
        } else {
            this.timesDesynced = 0;
            this.timeDiffSum = 0L;
        }
    }

    public int read(byte[] buf, int offset, int length) {
        int r = this.ringBuffer.read(buf, offset, length);
        if (r <= 0) {
            for (int i = 0; i < length; ++i) {
                buf[offset + i] = 0;
            }
            return length;
        }
        this.lastPtsRead = System.nanoTime();
        return r;
    }

    public void decodeDsp(Packet packet) {
        int samplesAvail;
        if (this.block.synthesis(packet) == 0) {
            this.dsp.synthesis_blockin(this.block);
        }
        int channels = this.info.channels;
        while ((samplesAvail = this.dsp.synthesis_pcmout(this.pcmAll, this.index)) > 0) {
            float[][] pcm = this.pcmAll[0];
            int samplesCanRead = this.UNCOMP_BUFSIZE / (channels * 2);
            int samplesToRead = samplesAvail < samplesCanRead ? samplesAvail : samplesCanRead;
            for (int i = 0; i < channels; ++i) {
                int writeOff = i * 2;
                int readOff = this.index[i];
                for (int j = 0; j < samplesToRead; ++j) {
                    int val = (int)((double)pcm[i][readOff + j] * 32767.0);
                    if (val > Short.MAX_VALUE) {
                        val = Short.MAX_VALUE;
                    }
                    if (val < Short.MIN_VALUE) {
                        val = Short.MIN_VALUE;
                    }
                    this.uncompBuf[writeOff] = (byte)val;
                    this.uncompBuf[writeOff + 1] = (byte)(val >> 8);
                    writeOff += 2 * channels;
                }
            }
            this.ringBuffer.write(this.uncompBuf, 0, samplesToRead * channels * 2);
            this.dsp.synthesis_read(samplesToRead);
        }
    }

    public void close() {
    }

    public void decode(Packet packet) {
        if (this.packetIndex < 3) {
            if (this.info.synthesis_headerin(this.comment, packet) < 0) {
                System.err.println("does not contain Vorbis audio data.");
                return;
            }
            if (this.packetIndex == 2) {
                SystemClock clock;
                this.dsp.synthesis_init(this.info);
                this.block.init(this.dsp);
                System.out.println("vorbis: " + this.info);
                System.out.println(this.comment.toString());
                this.index = new int[this.info.channels];
                if (this.stream == null) {
                    this.stream = new AudioStream();
                    this.stream.setupFormat(this.info.channels, 16, this.info.rate);
                    this.stream.updateData(this, -1.0f);
                }
                if (this.masterClock instanceof SystemClock && (clock = (SystemClock)this.masterClock).needReset()) {
                    clock.reset();
                    System.out.println("Note: master clock was reset by audio");
                }
            }
        } else {
            long gp = packet.granulepos;
            if (gp != -1L) {
                this.lastPts = gp * 1000000000L / (long)this.info.rate;
                this.lastWritten = this.ringBuffer.getTotalWritten();
                this.lastRead = this.ringBuffer.getTotalRead();
                this.lastPtsWrite = System.nanoTime();
            }
            this.decodeDsp(packet);
        }
        ++this.packetIndex;
    }
}

